<?php
header('Content-Type:application/json');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

    $n = trim($_POST['name'] ?? '');
    $capacity = isset($_POST['capacity']) && $_POST['capacity'] !== '' ? (int)$_POST['capacity'] : null;
    $pid = intval($_POST['parent_id'] ?? 0); 

    if (!$n) throw new Exception('Name required');

    $sql = "INSERT INTO classes (name, capacity, department_id) VALUES (:n, :capacity, :p)";
    $stmt = $pdo->prepare($sql);
    $execParams = [
        ':n' => $n,
        ':capacity' => $capacity !== null ? $capacity : null,
        ':p' => $pid > 0 ? $pid : null
    ];
    $stmt->execute($execParams);
    $newClassId = (int)$pdo->lastInsertId();

    function generate_and_save_qr($pdo, $department_id = null, $class_id = null, $section_id = null, $qrText = '') {
        $qrText = (string)$qrText;
        if ($qrText === '') return false;

        $uploadDir = '/uploads/class/';
        if (!is_dir($uploadDir)) {
            if (!@mkdir($uploadDir, 0755, true)) {
                error_log("Failed to create upload dir: $uploadDir");
                return false;
            }
        }

        $data = urlencode($qrText);
        $qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={$data}";

        // fetch image via cURL
        $ch = curl_init($qrUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        $img = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err = curl_error($ch);
        curl_close($ch);

        if ($img && $httpCode >= 200 && $httpCode < 300) {
            $filename = 'qr_' . time() . '_' . bin2hex(random_bytes(4)) . '.png';
            $fullPath = $uploadDir . $filename;
            if (file_put_contents($fullPath, $img) !== false) {
                $relativePath = 'Admin/uploads/class/' . $filename;

                $ins = $pdo->prepare("INSERT INTO class_qr_codes (department_id, class_id, section_id, qr_path, qr_code) VALUES (:d, :c, :s, :p, :q)");
                $ins->execute([
                    ':d' => $department_id ?: null,
                    ':c' => $class_id ?: null,
                    ':s' => $section_id ?: null,
                    ':p' => $relativePath,
                    ':q' => $qrText
                ]);
                return true;
            }
        }

        error_log("QR generation failed: httpCode={$httpCode} err={$err}");
        return false;
    }

    $topName = '';
    if ($pid > 0) {
        try {
            $q = $pdo->prepare("SELECT name FROM departments WHERE id = :id LIMIT 1");
            $q->execute([':id' => $pid]);
            $r = $q->fetch(PDO::FETCH_ASSOC);
            if ($r && isset($r['name'])) $topName = trim($r['name']);
        } catch (Exception $e) {
            // ignore
        }
    }

    $flow = $topName !== '' ? ($topName . ' > ' . $n) : $n;

    if ($capacity !== null && (int)$capacity > 0) {
        generate_and_save_qr($pdo, $pid > 0 ? $pid : null, $newClassId, null, $flow);
    }

    echo json_encode(['status' => 'success']);
    exit;

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit;
} ?>