<?php
require 'config.php';
header('Content-Type: application/json');
session_start();

$school_id    = (int)($_POST['school_id']    ?? 0);
$dept_id      = (int)($_POST['dept_id']      ?? 0);
$class_id     = (int)($_POST['class_id']     ?? 0);
$section_id   = (int)($_POST['section_id']   ?? 0);
$exam_name    = trim($_POST['exam_name']     ?? '');
$total_marks  = (int)($_POST['total_marks']  ?? 0);
$dt           = trim($_POST['exam_datetime'] ?? '');
$subjects_raw = $_POST['subjects'] ?? '[]';

if(!$school_id||!$dept_id||!$class_id||!$exam_name||!$total_marks||!$dt){
  echo json_encode(['success'=>false,'message'=>'All fields are required']);
  exit;
}

$subs = json_decode($subjects_raw,true);
if(!is_array($subs) || count($subs)===0){
  echo json_encode(['success'=>false,'message'=>'Add at least one subject']);
  exit;
}
$subjects_json = json_encode($subs);

try {
  $stmt = $pdo->prepare("INSERT INTO class_exams (school_id, dept_id, class_id, section_id, exam_name, total_marks, exam_datetime, subjects) VALUES (:sch,:dep,:cls,:sec,:name,:marks,:dt,:subs)");
  $stmt->execute(['sch' => $school_id, 'dep' => $dept_id, 'cls' => $class_id, 'sec' => $section_id, 'name' => $exam_name, 'marks'=> $total_marks, 'dt' => $dt, 'subs' => $subjects_json]);

  echo json_encode(['success'=>true,'message'=>'Exam added successfully']);

} catch(PDOException $e){
  error_log("PostExam Error: ".$e->getMessage());
  echo json_encode(['success'=>false,'message'=>'DB error, check logs']);
} ?>