<?php
header('Content-Type: application/json; charset=utf-8');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');
    $raw = $_POST['entries'] ?? null;
    if (!$raw) {
        $body = file_get_contents('php://input');
        $data = json_decode($body, true);
        $raw = $data['entries'] ?? null;
    }
    if (!$raw) throw new Exception('No entries provided');

    $entries = is_string($raw) ? json_decode($raw, true) : $raw;
    if (!is_array($entries) || empty($entries)) throw new Exception('Invalid entries');

    $adminSchool = isset($_SESSION['school']) ? $_SESSION['school'] : null;
    if (!$adminSchool) throw new Exception('School not set in session');

    $st = $pdo->prepare("SELECT id FROM listed_school WHERE school = :school LIMIT 1");
    $st->execute([':school'=>$adminSchool]);
    $r = $st->fetch(PDO::FETCH_ASSOC);
    $schoolId = $r['id'] ?? null;
    if (!$schoolId) throw new Exception('Invalid school');

    $pdo->beginTransaction();
    $ins = $pdo->prepare("INSERT INTO holidays (school_id, name, start_date, end_date, created_by) VALUES (:sid, :name, :s, :e, :by)");

    $createdBy = $_SESSION['id'] ?? null;
    $saved = 0;
    foreach ($entries as $ent) {
        $name = trim($ent['name'] ?? '');
        $s = trim($ent['start'] ?? '');
        $e = trim($ent['end'] ?? '');
        if (!$name || !$s) continue;
        if (!$e) $e = $s;
        $sd = DateTime::createFromFormat('Y-m-d',$s);
        $ed = DateTime::createFromFormat('Y-m-d',$e);
        if (!$sd || !$ed) continue;
        if ($sd > $ed) {
            $tmp = $s; $s = $e; $e = $tmp;
        }
        $ins->execute([':sid'=>$schoolId, ':name'=>$name, ':s'=>$s, ':e'=>$e, ':by'=>$createdBy]);
        $saved++;
    }

    $pdo->commit();
    echo json_encode(['status'=>'success', 'saved'=>$saved]);
    exit;
} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(400);
    echo json_encode(['status'=>'error', 'message'=>$e->getMessage()]);
    exit;
} ?>