<?php
header('Content-Type: application/json');
include 'config.php';

$school     = $_POST['schoolToken'] ?? '';
$teacher_id = $_POST['teacher_id'] ?? '';
$title      = trim($_POST['title'] ?? '');
$content    = trim($_POST['content'] ?? '');
$status     = $_POST['status'] ?? '';
$created_at = date('Y-m-d H:i:s');

$prov_doc_path = '';
if (!empty($_FILES['prov_doc']['name']) && $_FILES['prov_doc']['error'] === UPLOAD_ERR_OK) {
    $uploadDir  = '../api/uploads/docs/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    $filename   = time() . '_' . basename($_FILES['prov_doc']['name']);
    $targetPath = $uploadDir . $filename;
    if (move_uploaded_file($_FILES['prov_doc']['tmp_name'], $targetPath)) {
        $prov_doc_path = '/api/uploads/docs/' . $filename;
    }
}

try {
    $stmt = $pdo->prepare("INSERT INTO student_notice (teacher_id, created_at, title, description, prov_doc, school, status) VALUES (:teacher_id, :created_at, :title, :description, :prov_doc, :school, :status)");
    $stmt->execute([
        ':teacher_id'  => $teacher_id,
        ':created_at'  => $created_at,
        ':title'       => $title,
        ':description' => $content,
        ':prov_doc'    => $prov_doc_path,
        ':school'      => $school,
        ':status'      => $status
    ]);
    echo json_encode(['status' => 'success']);
} catch (Exception $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'DB error: ' . $e->getMessage()
    ]);
} ?>