<?php
header('Content-Type: application/json');
session_start();
if (empty($_SESSION['id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}
require '../config.php';

$input = json_decode(file_get_contents('php://input'), true);
$dept = (int)$input['department_id'];
$cls  = (int)$input['class_id'];
$sec  = isset($input['section_id']) ? (int)$input['section_id'] : null;
$tid  = (int)$input['teacher_id'];

$stmt = $pdo->prepare("REPLACE INTO class_teachers (department_id, class_id, section_id, teacher_id) VALUES (?,?,?,?)");
$stmt->execute([$dept, $cls, $sec, $tid]);

echo json_encode(['success' => true]); ?>