<?php
require 'config.php';
header('Content-Type: application/json');
session_start();

$data = json_decode(file_get_contents('php://input'), true);
$id   = isset($data['id']) ? (int)$data['id'] : 0;
$punch = isset($data['punch_id']) ? trim($data['punch_id']) : null;
if (!$id) {
    echo json_encode(['success'=>false, 'message'=>'Invalid ID']);
    exit;
}
if ($punch !== null) {
  if ($punch === '' || !preg_match('/^[A-Za-z0-9]{1,50}$/', $punch)) {
      echo json_encode(['success' => false, 'message' => 'Invalid Punch Id (only letters & numbers, max 50 chars)']);
      exit;
  }
}

try {
  $stmt = $pdo->prepare("SELECT school_token FROM students_temp WHERE id = :id LIMIT 1");
  $stmt->execute(['id' => $id]);   
  $row = $stmt->fetch(PDO::FETCH_ASSOC);
  if (!$row) {
    throw new Exception("Student not found");
  }
  $token = $row['school_token'];

  $stmt = $pdo->prepare("SELECT CAST(SUBSTRING_INDEX(student_uid,'-',-1) AS UNSIGNED) AS num FROM students_temp WHERE school_token = :token AND student_uid LIKE CONCAT(:token_like,'-%') ORDER BY num DESC LIMIT 1");
  $stmt->execute(['token' => $token, 'token_like'=> $token]);
  $last = $stmt->fetchColumn();
  $lastNum = $last !== false ? (int)$last : 0;

  $nextNum = $lastNum + 1;
  $suffix = $nextNum < 10000 ? str_pad($nextNum, 4, '0', STR_PAD_LEFT) : (string)$nextNum;
  $studentUid = "{$token}-{$suffix}";

  $plainPwd  = bin2hex(random_bytes(4));
  $hashedPwd = password_hash($plainPwd, PASSWORD_BCRYPT);
  $sts       = 'Approved';

  $stmt = $pdo->prepare("UPDATE students_temp SET is_approved = 1, student_punch_id = :punch, password = :hashedpwd, status = :sts, student_uid = :uid WHERE id = :id");
  $stmt->execute(['punch' => $punch, 'hashedpwd' => $hashedPwd, 'sts' => $sts, 'uid' => $studentUid, 'id' => $id]);

  $stmt = $pdo->prepare("SELECT email, name FROM students_temp WHERE id = :id");
  $stmt->execute(['id' => $id]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  $to  = $user['email'];
  $sub = "Your account has been approved";
  $msg = "Hi {$user['name']},\n\n" .
        "Your registration is approved!\n" .
        "Your temporary password is: {$plainPwd}\n" .
        "Your student ID is: {$studentUid}\n\n" .
        "Please login and change it ASAP.";

  mail($to, $sub, $msg);

  echo json_encode([
    'success' => true,
    'message' => "Approved & assigned UID {$studentUid}"
  ]);

} catch (Exception $e) {
  error_log("ApproveStudent Error: " . $e->getMessage());
  error_log($e->getTraceAsString());

  echo json_encode([
    'success' => false,
    'message' => 'An internal error occurred. Check logs.'
  ]);
  exit;
} ?>