<?php
header('Content-Type:application/json');
session_start();
require 'config.php';
if (empty($_SESSION['id'])) {
  echo json_encode(['status'=>'error','message'=>'Unauthorized']);
  exit;
}

$body = json_decode(file_get_contents('php://input'), true);
$id   = intval($body['id'] ?? 0);
if (!$id) {
  echo json_encode(['status'=>'error','message'=>'Invalid request']);
  exit;
}

try {
  $stmt1 = $pdo->prepare("SELECT prov_doc FROM student_notice WHERE id = :id AND teacher_id = :tid");
  $stmt1->execute([':id' => $id, ':tid' => $_SESSION['id']]);
  $row = $stmt1->fetch(PDO::FETCH_ASSOC);

  if ($row && !empty($row['prov_doc'])) {
    $file = '..' . $row['prov_doc'];
    if (is_file($file) && is_writable($file)) {
      @unlink($file); 
    }
  }

  $stmt2 = $pdo->prepare("DELETE FROM student_notice WHERE id = :id AND teacher_id = :tid");
  $stmt2->execute([':id' => $id, ':tid' => $_SESSION['id']]);

  echo json_encode(['status'=>'success', 'message'=>'Notice deleted']);
} catch (PDOException $e) {
  echo json_encode(['status'=>'error','message'=>'DB Error: '.$e->getMessage()]);
} ?>