<?php
require 'config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$id   = isset($data['id']) ? (int)$data['id'] : 0;

if ($id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid student ID']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT image FROM students_temp WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(['success' => false, 'message' => 'Student not found']);
        exit;
    }

    $filename = $row['image'];
    $filepath = __DIR__ . '/../Student/' . $filename;

    if ($filename && file_exists($filepath)) {
        if (!unlink($filepath)) {
            echo json_encode([
                'success' => false,
                'message' => "Could not delete image file: $filename"
            ]);
            exit;
        }
    }

    $del = $pdo->prepare("DELETE FROM students_temp WHERE id = :id");
    $del->execute([':id' => $id]);

    echo json_encode([
        'success' => true,
        'message' => 'Student and image removed successfully'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
} ?>