<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
if(empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Not authenticated']); exit;
}
include "config.php"; 

try {
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    if (!$id) {
        echo json_encode(['status'=>'error','message'=>'Missing id']); exit;
    }

    $stmt = $pdo->prepare("DELETE FROM school_registered_rfid_machines WHERE id = ?");
    $ok = $stmt->execute([$id]);

    if ($ok) {
        if ($stmt->rowCount() > 0) {
            echo json_encode(['status'=>'success','message'=>'Gate deleted successfully']);
        } else {
            echo json_encode(['status'=>'error','message'=>'Gate not found or not permitted']);
        }
    } else {
        echo json_encode(['status'=>'error','message'=>'Database error while deleting']);
    }
} catch (Exception $ex) {
    error_log("gates_delete error: ".$ex->getMessage());
    echo json_encode(['status'=>'error','message'=>'Server error']);
} ?>