<?php
header('Content-Type: application/json; charset=utf-8');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

    $copy_code = isset($_GET['copy_code']) ? trim($_GET['copy_code']) : '';
    if ($copy_code === '') throw new Exception('No code provided');

    $sql = "SELECT sab.id AS assigned_id, sab.book_id AS copy_code, sab.pickup_date,
      sab.supposed_submit_date, sab.actual_submit_date, sab.status AS sab_status, sab.student_id, st.name AS student_name,
      st.email AS student_email, st.phone AS student_phone, bc.book_id AS book_id, b.name AS book_name, b.author, b.image FROM student_assigned_books sab
      JOIN book_copies bc ON sab.book_id = bc.copy_code JOIN books b ON bc.book_id = b.id JOIN students_temp st ON sab.student_id = st.id
      WHERE sab.book_id = :copy_code AND (sab.actual_submit_date IS NULL OR sab.actual_submit_date = '') ORDER BY sab.pickup_date DESC LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':copy_code' => $copy_code]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(['status' => 'error', 'message' => 'No active assignment found for this copy code']);
        exit;
    }

    echo json_encode(['status' => 'success', 'data' => $row]);
    exit;
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit;
} ?>