<?php
header('Content-Type: application/json; charset=utf-8');
require 'config.php';
session_start();

try {
    if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

    $from = isset($_GET['from']) ? trim($_GET['from']) : null;
    $to   = isset($_GET['to'])   ? trim($_GET['to'])   : null;

    if (!$from || !$to) {
        echo json_encode(['holidays' => []]);
        exit;
    }

    $adminSchool = isset($_SESSION['school']) ? $_SESSION['school'] : null;
    $schoolId = null;
    if ($adminSchool) {
        $st = $pdo->prepare("SELECT id FROM listed_school WHERE school = :school LIMIT 1");
        $st->execute([':school'=>$adminSchool]);
        $r = $st->fetch(PDO::FETCH_ASSOC);
        $schoolId = $r['id'] ?? null;
    }
    if (!$schoolId) {
        echo json_encode(['holidays' => []]);
        exit;
    }

    $sql = "SELECT id, name, start_date, end_date FROM holidays WHERE school_id = :sid AND NOT (end_date < :from OR start_date > :to) ORDER BY start_date ASC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':sid'=>$schoolId, ':from'=>$from, ':to'=>$to]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['holidays' => $rows]);
    exit;
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
    exit;
} ?>