<?php
header('Content-Type: application/json');
require 'config.php';

try {
  $id     = (int)($_POST['id'] ?? 0);
  $status = trim($_POST['status'] ?? '');

  if (!$id || !in_array($status, ['Approved','Rejected','Provide Doc'])) {
    throw new Exception('Invalid parameters');
  }

  $stmt = $pdo->prepare("UPDATE student_guardian_letter SET current_status = :st, approve_reject_time = NOW() WHERE id = :id");
  $stmt->execute([':st'=>$status,':id'=>$id]);

  echo json_encode(['status'=>'success']);
} catch(\Exception $e){
  echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
} ?>