<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

function json($ok,$msg){ echo json_encode(['status'=>$ok,'message'=>$msg]); exit; }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json(false,'Invalid request');
$email = trim($_POST['email'] ?? '');
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) json(false,'Enter a valid email');

try {
    $stmt = $pdo->prepare("SELECT id FROM superadmin WHERE email = :email LIMIT 1");
    $stmt->execute([':email'=>$email]);
    $row = $stmt->fetch();
    if (!$row) json(false, 'No account found with this email');

    $teacherId = (int)$row['id'];
    $otp = random_int(1000, 9999);
    $expires = time() + 300; // 5 minutes

    $_SESSION['pwd_reset'] = [
        'email' => $email,
        'otp' => (string)$otp,
        'expires' => $expires,
        'teacher_id' => $teacherId
    ];

    $host = $_SERVER['HTTP_HOST'] ?? 'example.com';
    $subject = "Your OTP for password reset";
    $message = "Your 4-digit OTP for password reset is: $otp\n\nThis code will expire in 5 minutes.\n\nIf you didn't request this, ignore this email.";
    $headers = "From: no-reply@{$host}\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/plain; charset=utf-8\r\n";

    $sent = @mail($email, $subject, $message, $headers);

    if ($sent) {
        json(true, 'OTP sent to your email (may take a moment).');
    } else {
        json(false, 'Failed to send OTP email. Server mail is not configured.');
    }

} catch (PDOException $e) {
    json(false, 'Server error: '.$e->getMessage());
} ?>