<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

if (empty($email) || empty($password)) {
    echo json_encode(['status' => 'error', 'message' => 'Please provide both email and password']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id, name, email, password, is_mini_superadmin, permission_add_school, permission_create_admin, permission_view_activity, permission_create_mini FROM superadmin WHERE email = :email LIMIT 1");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['id'] = $user['id'];
        $_SESSION['name'] = $user['name'];
        $_SESSION['email'] = $user['email'];
        $_SESSION['is_mini_superadmin'] = (int)$user['is_mini_superadmin'];

        $_SESSION['perm_add_school'] = (int)$user['permission_add_school'];
        $_SESSION['perm_create_admin'] = (int)$user['permission_create_admin'];
        $_SESSION['perm_view_activity'] = (int)$user['permission_view_activity'];
        $_SESSION['perm_create_mini'] = (int)$user['permission_create_mini'];

        echo json_encode(['status' => 'success', 'message' => 'Login successful! Redirecting...']);

    } else {echo json_encode(['status' => 'error', 'message' => 'Invalid email or password']);}

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error']);
} ?>