<?php
session_start();
require_once 'config.php';
header('Content-Type: application/json');

if (empty($_SESSION['id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']); exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request']); exit;
}
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if (!$id) {
    echo json_encode(['status'=>'error','message'=>'Invalid id']); exit;
}

try {
    $stmt = $pdo->prepare("SELECT email FROM superadmin WHERE id = ? AND is_mini_superadmin = 1 LIMIT 1");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) {
        echo json_encode(['status'=>'error','message'=>'Mini account not found']); exit;
    }
} catch (PDOException $e) {
    echo json_encode(['status'=>'error','message'=>'Server error']); exit;
}

try {
    $otp = random_int(100000, 999999);
} catch (Exception $e) {
    $otp = mt_rand(100000, 999999);
}
$expires = 300;
$now = time();

$_SESSION['delete_otp'] = [
    'otp' => (string)$otp,
    'id' => $id,
    'created_at' => $now,
    'expires_at' => $now + $expires
];
$recipient_email = 'tuhinsarkar581@gmail.com';  
$accountEmail = htmlspecialchars($row['email'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');

$subject = "Kolkata Dealer — OTP to confirm deletion";
$from_email = 'no-reply@yourdomain.com'; 
$from_name = 'Kolkata Dealer';

$message = '
<!doctype html>
<html>
<head><meta charset="utf-8"></head>
<body style="margin:0;padding:0;background:#f7f7fb;font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans;">
  <table width="100%" cellpadding="0" cellspacing="0" role="presentation">
    <tr><td align="center" style="padding:36px 12px;">
      <table width="600" cellpadding="0" cellspacing="0" role="presentation" style="background:#ffffff;border-radius:12px;overflow:hidden;box-shadow:0 10px 30px rgba(0,0,0,0.08);">
        <tr>
          <td style="padding:20px 28px;">
            <div style="display:flex;align-items:center;gap:12px;">
              <div>
                <div style="font-size:18px;font-weight:700;color:#222;">Kolkata Dealer</div>
                <div style="font-size:13px;color:#666;margin-top:2px;">OTP to confirm mini-admin deletion</div>
              </div>
            </div>
          </td>
        </tr>

        <tr>
          <td style="padding:12px 28px 28px;">
            <div style="margin-top:8px;color:#333;font-size:15px;line-height:1.45;">
              <p style="margin:0 0 8px 0;">You requested to delete the mini-superadmin account: <strong>' . $accountEmail . '</strong></p>
              <p style="margin:0 0 18px 0;color:#555;">Use the following one-time code to confirm deletion. This code is valid for 5 minutes.</p>

              <div style="display:flex;align-items:center;justify-content:center;margin:18px 0;">
                <div style="background:#fff;border:2px dashed #E8E8F8;padding:18px 28px;border-radius:12px;">
                  <div style="font-size:26px;letter-spacing:4px;color:#4D44B5;font-weight:700;text-align:center;">' . $otp . '</div>
                </div>
              </div>

              <p style="margin:0;color:#666;font-size:13px;">If you did not request this, ignore this email. <strong>Do not share this code with anyone.</strong></p>
            </div>
          </td>
        </tr>

        <tr>
          <td style="padding:18px 28px;background:linear-gradient(90deg,#4D44B5,#FB7D5B);color:#fff;">
            <div style="font-weight:600;">Kolkata Dealer</div>
            <div style="font-size:12px;opacity:0.92;margin-top:4px;">School Management Software</div>
          </td>
        </tr>
      </table>
    </td></tr>
  </table>
</body>
</html>';

$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html;charset=UTF-8\r\n";
$headers .= "From: " . $from_name . " <" . $from_email . ">\r\n";

$sent = @mail($recipient_email, $subject, $message, $headers);

if ($sent) {
    echo json_encode(['status'=>'success','message'=>'OTP sent to authorized email','expires_in'=>$expires]);
} else {
    echo json_encode(['status'=>'error','message'=>'Failed to send OTP via mail() — check server mail settings']);
} ?>