<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

if (empty($_SESSION['id'])) {
    echo json_encode(['ok'=>false,'msg'=>'Not authenticated']);
    exit;
}
$school_id = (int)($_POST['school_id'] ?? 0);
if (!$school_id) {
    echo json_encode(['ok'=>false,'msg'=>'Invalid school id']);
    exit;
}

$stmt = $pdo->prepare("SELECT is_active FROM listed_school WHERE id = :id LIMIT 1");
$stmt->execute([':id' => $school_id]);
$cur = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$cur) {
    echo json_encode(['ok'=>false,'msg'=>'School not found']);
    exit;
}
$current = strtolower((string)$cur['is_active']);
if ($current === 'active' || $current === '1' || $current === 'true') {
    $new = 'inactive';
} else {
    $new = 'active';
}
$upd = $pdo->prepare("UPDATE listed_school SET is_active = :new WHERE id = :id");
$ok  = $upd->execute([':new' => $new, ':id' => $school_id]);

if ($ok) {
    echo json_encode(['ok'=>true,'status'=>$new]);
} else {
    echo json_encode(['ok'=>false,'msg'=>'DB update failed']);
} ?>