<?php
require 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['status'=>'error','message'=>'Invalid request']);
  exit;
}

$id = intval($_POST['id'] ?? 0);
$password = trim($_POST['password'] ?? '');

if (!$id || !$password) {
  http_response_code(400);
  echo json_encode(['status'=>'error','message'=>'Missing data']);
  exit;
}
$hash = password_hash($password, PASSWORD_BCRYPT);

try {
  $stmt = $pdo->prepare("UPDATE admin SET password = :pwd WHERE id = :id");
  $stmt->execute([':pwd'=>$hash, ':id'=>$id]);
  
  echo json_encode(['status'=>'success']);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['status'=>'error','message'=>'Database error']);
} ?>