<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

try {
  if (empty($_SESSION['id'])) throw new Exception('Unauthorized');

  $cid  = (int)($_POST['parent_id'] ?? 0); 
  $name = trim($_POST['name'] ?? '');
  $capacity = isset($_POST['capacity']) && $_POST['capacity'] !== '' ? (int)$_POST['capacity'] : null;

  if (!$cid || !$name) throw new Exception('Invalid data');

  $stmt = $pdo->prepare("INSERT INTO sections (class_id, name, capacity) VALUES (:c, :n, :capacity)");
  $stmt->execute([':c' => $cid, ':n' => $name, ':capacity' => $capacity]);
  $newSectionId = (int)$pdo->lastInsertId();

  $className = '';
  $topDeptId = null;
  try {
    $q = $pdo->prepare("SELECT name, department_id FROM classes WHERE id = :id LIMIT 1");
    $q->execute([':id' => $cid]);
    $r = $q->fetch(PDO::FETCH_ASSOC);
    if ($r) {
      $className = isset($r['name']) ? trim($r['name']) : '';
      $topDeptId = isset($r['department_id']) ? (int)$r['department_id'] : null;
    }
  } catch (Exception $e) {
    // ignore; we'll still try to build flow with available data
  }

  $topName = '';
  if ($topDeptId) {
    try {
      $q2 = $pdo->prepare("SELECT name FROM departments WHERE id = :id LIMIT 1");
      $q2->execute([':id' => $topDeptId]);
      $r2 = $q2->fetch(PDO::FETCH_ASSOC);
      if ($r2 && isset($r2['name'])) $topName = trim($r2['name']);
    } catch (Exception $e) {
      // ignore
    }
  }

  function generate_and_save_qr($pdo, $department_id = null, $class_id = null, $section_id = null, $qrText = '') {
    $qrText = (string)$qrText;
    if ($qrText === '') return false;

    $uploadDir = '../Admin/uploads/class/';
    if (!is_dir($uploadDir)) {
      if (!@mkdir($uploadDir, 0755, true)) {
        error_log("Failed to create upload dir: $uploadDir");
        return false;
      }
    }

    $data = urlencode($qrText);
    $qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={$data}";

    // fetch image via cURL
    $ch = curl_init($qrUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $img = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);

    if ($img && $httpCode >= 200 && $httpCode < 300) {
      $filename = 'qr_' . time() . '_' . bin2hex(random_bytes(4)) . '.png';
      $fullPath = $uploadDir . $filename;
      if (file_put_contents($fullPath, $img) !== false) {
        $relativePath = 'Admin/uploads/class/' . $filename;

        $ins = $pdo->prepare("INSERT INTO class_qr_codes (department_id, class_id, section_id, qr_path, qr_code) VALUES (:d, :c, :s, :p, :q)");
        $ins->execute([
          ':d' => $department_id ?: null,
          ':c' => $class_id ?: null,
          ':s' => $section_id ?: null,
          ':p' => $relativePath,
          ':q' => $qrText
        ]);
        return true;
      }
    }

    error_log("QR generation failed: httpCode={$httpCode} err={$err}");
    return false;
  }

  $parts = [];
  if ($topName !== '') $parts[] = $topName;
  if ($className !== '') $parts[] = $className;
  $parts[] = $name; 
  $flow = implode(' > ', $parts);

  if ($capacity !== null && (int)$capacity > 0) {
    generate_and_save_qr($pdo, $topDeptId ?: null, $cid, $newSectionId, $flow);
  }

  echo json_encode(['status' => 'success']);
  exit;

} catch(Exception $e){
  echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
  exit;
} ?>