<?php
header('Content-Type: application/json');
require_once 'config.php';

try {
    $teacher_id = filter_input(INPUT_POST, 'teacher_id', FILTER_VALIDATE_INT);
    $subject_id = filter_input(INPUT_POST, 'subject_id', FILTER_VALIDATE_INT);

    if (!$teacher_id || !$subject_id) {
        throw new Exception('Invalid teacher or subject selection.');
    }

    $check = $pdo->prepare("SELECT COUNT(*) FROM teacher_subjects WHERE teacher_id = :t AND subjects = :s");
    $check->execute([':t' => $teacher_id, ':s' => $subject_id]);
    if ($check->fetchColumn() > 0) {
        throw new Exception('This teacher is already assigned to that subject.');
    }

    $stmt = $pdo->prepare("INSERT INTO teacher_subjects (teacher_id, subjects) VALUES (:t, :s)");
    $stmt->execute([
        ':t' => $teacher_id,
        ':s' => $subject_id
    ]);

    echo json_encode([
        'success' => true,
        'message' => 'Teacher assigned successfully!'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} ?>