<?php
header('Content-Type: application/json');
require 'config.php';
session_start();

if (empty($_SESSION['id'])) {
    echo json_encode([]);
    exit;
}

$dept = (int)($_GET['dept_id']    ?? 0);
$cls  = (int)($_GET['class_id']   ?? 0);
$sec  = (int)($_GET['section_id'] ?? 0);

$school = $_SESSION['school'];
$stmt   = $pdo->prepare("SELECT token FROM listed_school WHERE school = :school LIMIT 1");
$stmt->execute([':school' => $school]);
$row        = $stmt->fetch(PDO::FETCH_ASSOC);
$schoolToken= $row['token'] ?? '';

if (!$dept || !$cls) {
    echo json_encode([]);
    exit;
}

$sql = "SELECT s.id, s.roll_no, s.name, s.dob, s.age, s.email, s.phone, s.student_uid, s.image, s.student_qr AS student_qr, s.is_active,
    d.name AS department, c.name AS class, sec.name AS section FROM students_temp s
    JOIN departments d ON d.id = s.department_id JOIN classes c ON c.id = s.class_id LEFT JOIN sections sec ON sec.id = s.section_id
    WHERE s.status = 'Assigned' AND s.is_approved = 1 AND s.school_token = :school AND s.department_id = :dept AND s.class_id = :cls";

$params = [':school' => $schoolToken, ':dept' => $dept, ':cls' => $cls];

if ($sec) {
    $sql .= " AND s.section_id = :sec";
    $params[':sec'] = $sec;
}

$sql .= " ORDER BY s.roll_no";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); ?>