<?php
session_start();
if(empty($_SESSION['id'])){ echo '<script>window.location.href="signin.php"</script>'; }
include "config.php";
include 'headerlink.php';

$deptStmt = $pdo->query("SELECT id, name FROM departments ORDER BY name");
$departments = $deptStmt->fetchAll(PDO::FETCH_ASSOC); ?>

    <div id="main-wrapper" class="wallet-open active">
	
        <!--Nav header-->
        <div class="nav-header">
            <a href="dashboard.php" class="brand-logo">
				<!-- <svg class="logo-abbr" width="40" height="40" viewBox="0 0 48 54" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect y="3" width="48" height="48" rx="16" fill="#FB7D5B"></rect>
					<path d="M28.964 35.536H19.532L18.02 40H11.576L20.72 14.728H27.848L36.992 40H30.476L28.964 35.536ZM27.38 30.784L24.248 21.532L21.152 30.784H27.38Z" fill="white"></path>
				</svg> -->
				<div class="brand-title">
					<!-- <svg width="140" height="30" viewBox="0 0 167 30" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M17.964 24.536H8.532L7.02 29H0.576L9.72 3.728H16.848L25.992 29H19.476L17.964 24.536ZM16.38 19.784L13.248 10.532L10.152 19.784H16.38ZM41.051 29L34.931 20.576V29H28.775V2.36H34.931V17.084L41.015 8.912H48.611L40.259 18.992L48.683 29H41.051ZM49.8049 18.92C49.8049 16.856 50.1889 15.044 50.9569 13.484C51.7489 11.924 52.8169 10.724 54.1609 9.884C55.5049 9.044 57.0049 8.624 58.6609 8.624C60.0769 8.624 61.3129 8.912 62.3689 9.488C63.4489 10.064 64.2769 10.82 64.8529 11.756V8.912H71.0089V29H64.8529V26.156C64.2529 27.092 63.4129 27.848 62.3329 28.424C61.2769 29 60.0409 29.288 58.6249 29.288C56.9929 29.288 55.5049 28.868 54.1609 28.028C52.8169 27.164 51.7489 25.952 50.9569 24.392C50.1889 22.808 49.8049 20.984 49.8049 18.92ZM64.8529 18.956C64.8529 17.42 64.4209 16.208 63.5569 15.32C62.7169 14.432 61.6849 13.988 60.4609 13.988C59.2369 13.988 58.1929 14.432 57.3289 15.32C56.4889 16.184 56.0689 17.384 56.0689 18.92C56.0689 20.456 56.4889 21.68 57.3289 22.592C58.1929 23.48 59.2369 23.924 60.4609 23.924C61.6849 23.924 62.7169 23.48 63.5569 22.592C64.4209 21.704 64.8529 20.492 64.8529 18.956ZM74.2385 18.92C74.2385 16.856 74.6225 15.044 75.3905 13.484C76.1825 11.924 77.2505 10.724 78.5945 9.884C79.9385 9.044 81.4385 8.624 83.0945 8.624C84.4145 8.624 85.6145 8.9 86.6945 9.452C87.7985 10.004 88.6625 10.748 89.2865 11.684V2.36H95.4425V29H89.2865V26.12C88.7105 27.08 87.8825 27.848 86.8025 28.424C85.7465 29 84.5105 29.288 83.0945 29.288C81.4385 29.288 79.9385 28.868 78.5945 28.028C77.2505 27.164 76.1825 25.952 75.3905 24.392C74.6225 22.808 74.2385 20.984 74.2385 18.92ZM89.2865 18.956C89.2865 17.42 88.8545 16.208 87.9905 15.32C87.1505 14.432 86.1185 13.988 84.8945 13.988C83.6705 13.988 82.6265 14.432 81.7625 15.32C80.9225 16.184 80.5025 17.384 80.5025 18.92C80.5025 20.456 80.9225 21.68 81.7625 22.592C82.6265 23.48 83.6705 23.924 84.8945 23.924C86.1185 23.924 87.1505 23.48 87.9905 22.592C88.8545 21.704 89.2865 20.492 89.2865 18.956ZM118.832 18.632C118.832 19.208 118.796 19.808 118.724 20.432H104.792C104.888 21.68 105.284 22.64 105.98 23.312C106.7 23.96 107.576 24.284 108.608 24.284C110.144 24.284 111.212 23.636 111.812 22.34H118.364C118.028 23.66 117.416 24.848 116.528 25.904C115.664 26.96 114.572 27.788 113.252 28.388C111.932 28.988 110.456 29.288 108.824 29.288C106.856 29.288 105.104 28.868 103.568 28.028C102.032 27.188 100.832 25.988 99.9681 24.428C99.1041 22.868 98.6721 21.044 98.6721 18.956C98.6721 16.868 99.0921 15.044 99.9321 13.484C100.796 11.924 101.996 10.724 103.532 9.884C105.068 9.044 106.832 8.624 108.824 8.624C110.768 8.624 112.496 9.032 114.008 9.848C115.52 10.664 116.696 11.828 117.536 13.34C118.4 14.852 118.832 16.616 118.832 18.632ZM112.532 17.012C112.532 15.956 112.172 15.116 111.452 14.492C110.732 13.868 109.832 13.556 108.752 13.556C107.72 13.556 106.844 13.856 106.124 14.456C105.428 15.056 104.996 15.908 104.828 17.012H112.532ZM147.712 8.696C150.208 8.696 152.188 9.452 153.652 10.964C155.14 12.476 155.884 14.576 155.884 17.264V29H149.764V18.092C149.764 16.796 149.416 15.8 148.72 15.104C148.048 14.384 147.112 14.024 145.912 14.024C144.712 14.024 143.764 14.384 143.068 15.104C142.396 15.8 142.06 16.796 142.06 18.092V29H135.94V18.092C135.94 16.796 135.592 15.8 134.896 15.104C134.224 14.384 133.288 14.024 132.088 14.024C130.888 14.024 129.94 14.384 129.244 15.104C128.572 15.8 128.236 16.796 128.236 18.092V29H122.08V8.912H128.236V11.432C128.86 10.592 129.676 9.932 130.684 9.452C131.692 8.948 132.832 8.696 134.104 8.696C135.616 8.696 136.96 9.02 138.136 9.668C139.336 10.316 140.272 11.24 140.944 12.44C141.64 11.336 142.588 10.436 143.788 9.74C144.988 9.044 146.296 8.696 147.712 8.696ZM163.285 6.824C162.205 6.824 161.317 6.512 160.621 5.888C159.949 5.24 159.613 4.448 159.613 3.512C159.613 2.552 159.949 1.76 160.621 1.136C161.317 0.487998 162.205 0.163998 163.285 0.163998C164.341 0.163998 165.205 0.487998 165.877 1.136C166.573 1.76 166.921 2.552 166.921 3.512C166.921 4.448 166.573 5.24 165.877 5.888C165.205 6.512 164.341 6.824 163.285 6.824ZM166.345 8.912V29H160.189V8.912H166.345Z" fill="white"></path>
					</svg> -->
					<h4 class="fw-bold text-white">Kolkata Dealer</h4>
				</div> 
            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
					<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="11" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="11" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect x="22" y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
						<rect y="22" width="4" height="4" rx="2" fill="#2A353A"></rect>
					</svg>		
                </div>
            </div>
        </div>
        <!--/Nav header-->
		
		<!-- header -->
		<div class="header">
			<div class="header-content">
				<nav class="navbar navbar-expand">
					<div class="collapse navbar-collapse justify-content-between">
						<div class="header-left">
							<div class="dashboard_bar">Receive Book</div>
						</div>
						<?php include "header.php"; ?>
					</div>
				</nav>
			</div>
		</div>
		<!-- /header -->

		<?php include "sidebar.php"; ?>

        <!--Content body-->
		<div class="content-body">
			<div class="container-fluid">
                <div class="row">
					<div class="col-xl-12">
						<div class="card border-0 rounded-4 p-3">
							<div class="d-flex justify-content-between align-items-center mb-4">
								<h4 class="mb-0 fw-semibold"><i class="bi bi-people me-2"></i>All Students List</h4>
							</div>
                            <!-- QR Code -------------------- -->
                            <div class="row mb-3">
                                <div class="col-12">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="mb-1">Quick QR Scanner</h5>
                                            <p class="mb-0 text-muted small">Scan a book QR (copy code) using your device camera.</p>
                                        </div>
                                        <div class="text-end">
                                            <button id="openScanPermBtn" class="btn btn-outline-primary">
                                                <i class="bi bi-camera me-1"></i> Scan QR
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /QR Code ------------------- -->
                            <!-- Filters -------------------- -->
                            <div class="row mb-4">
                                <!-- Department -->
                                <div class="col-md-4">
                                    <div class="form-floating position-relative">
                                        <select id="filterDept" class="form-select bg-light border-0" aria-label="Department">
                                            <option value="" selected disabled>Select Class</option>
                                            <?php foreach($departments as $d): ?>
                                            <option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['name']) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <label for="filterDept"><i class="bi bi-building me-1"></i>Class</label>
                                    </div>
                                </div>
                                <!-- Class -->
                                <div class="col-md-4">
                                    <div class="form-floating position-relative">
                                        <select id="filterClass" class="form-select bg-light border-0" disabled aria-label="Class">
                                            <option value="" selected disabled>Select Department</option>
                                        </select>
                                        <label for="filterClass"><i class="bi bi-journal-bookmark me-1"></i>Department</label>
                                    </div>
                                </div>
                                <!-- Section -->
                                <div class="col-md-4">
                                    <div class="form-floating position-relative">
                                        <select id="filterSection" class="form-select bg-light border-0" disabled aria-label="Section">
                                            <option value="" selected disabled>Select Section</option>
                                        </select>
                                        <label for="filterSection"><i class="bi bi-layout-text-window-reverse me-1"></i>Section</label>
                                    </div>
                                </div>
                            </div>
                            <!-- /Filters ------------------- -->
							<div class="table-responsive admin_table">
                                <table id="studentsTable" class="table table-hover align-middle">
                                    <thead class="table-light text-uppercase small">
                                        <tr>
                                            <th class="fw-bold text-primary">Roll No.</th>
                                            <th class="fw-bold text-primary">Student Name</th>
                                            <th class="fw-bold text-primary">Guardian Contacts</th>
                                            <th class="fw-bold text-primary">Class Details</th>
                                            <th class="fw-bold text-primary">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
						</div>
					</div>
				</div>
                <!-- camera permission + camera + result window modal ================== -->

                <!-- camera permission modal -->
                <div class="modal fade" id="cameraPermissionModal" tabindex="-1">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content rounded-4 shadow-sm">
                            <div class="modal-header">
                                <h5 class="modal-title">Camera Permission</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <p>Allow access to your webcam to scan book QR codes. The camera stream is used only in-browser and not uploaded anywhere.</p>
                                <p class="small text-muted mb-0">Tip: Use a desktop/laptop webcam or attach a phone camera. For best scans, hold the QR near the camera with good lighting.</p>
                            </div>
                            <div class="modal-footer">
                                <button id="cameraNoBtn" class="btn btn-outline-secondary" data-bs-dismiss="modal">No, cancel</button>
                                <button id="cameraYesBtn" class="btn btn-primary">Yes, open camera</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Scanner Modal -->
                <div class="modal fade" id="scannerModal" tabindex="-1">
                    <div class="modal-dialog modal-xl modal-dialog-centered">
                        <div class="modal-content rounded-4 shadow-sm">
                            <div class="modal-header">
                                <h5 class="modal-title">Scan QR Code</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row g-3">
                                    <div class="col-lg-8">
                                        <div class="border rounded-3 overflow-hidden position-relative" style="min-height:360px;">
                                            <video id="qrVideo" autoplay playsinline style="width:100%;height:100%;object-fit:cover;background:#000;"></video>
                                            <canvas id="qrCanvas" style="display:none;"></canvas>
                                            <div id="qrOverlay" style="position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);pointer-events:none;">
                                                <div style="width:220px;height:220px;border:2px dashed rgba(255,255,255,0.6);border-radius:12px;"></div>
                                            </div>
                                        </div>
                                        <div class="mt-2 small text-muted">When QR is detected the scanner will stop and show results. Close the scanner to re-open camera.</div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="card p-3 h-100">
                                            <h6>Instructions</h6>
                                            <ul class="small">
                                                <li>Allow camera access when prompted.</li>
                                                <li>Hold the book QR in front of the camera until it reads.</li>
                                                <li>Ensure good lighting and steady hands.</li>
                                            </ul>
                                            <div id="scanStatus" class="mt-3 text-muted small">Idle — click start to begin scanning.</div>
                                            <div class="mt-3 d-flex gap-2">
                                                <button id="startScannerBtn" class="btn btn-success">Start</button>
                                                <button id="stopScannerBtn" class="btn btn-outline-secondary" disabled>Stop</button>
                                                <button id="closeScannerBtn" class="btn btn-outline-danger" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- QR Result Modal -->
                <div class="modal fade" id="qrResultModal" tabindex="-1">
                    <div class="modal-dialog modal-md modal-dialog-centered">
                        <div class="modal-content rounded-4 shadow-sm">
                            <div class="modal-header">
                                <h5 class="modal-title">Scanned Assignment</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div id="qrResultBody">
                                    <div class="text-center text-muted">Loading…</div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button id="qrMarkLostBtn" class="btn btn-danger">Mark as Lost</button>
                                <button id="qrReceiveBtn" class="btn btn-primary">Receive Book</button>
                                <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- /camera permission + camera + result window modal ================== -->
                <!-- Book Receive Modal -->
                <div class="modal fade" id="receiveBookModal" tabindex="-1">
                    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                        <div class="modal-content rounded-4 shadow-sm">
                            <div class="modal-header">
                                <h5 class="modal-title">Receive Book(s) from Student</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div id="receiveModalAssigned" class="mb-3">
                                    <h6 class="mb-2">Assigned Books</h6>
                                    <div id="assignedBooksWrap" class="row g-2">Loading…</div>
                                </div>
                                <hr/>
                                <div class="mb-3">
                                    <h6 class="mb-2">Select books to process</h6>
                                    <div id="receiveSelectWrap" class="row g-3">Loading…</div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <label for="receiveActualDate" class="form-label">Actual Submit Date & Time</label>
                                        <input id="receiveActualDate" type="datetime-local" class="form-control">
                                    </div>
                                </div>
                                <div id="receiveAlert" class="mt-3" style="display:none;"></div>
                            </div>
                            <div class="modal-footer">
                                <button id="markLostBtn" class="btn btn-danger">Mark as Lost</button>
                                <button id="receiveSubmitBtn" class="btn btn-primary">Receive Selected Books</button>
                                <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Book Receive Modal -->
			</div>
		</div>

		<?php include "footer.php" ?>

	</div>
    
<!-- All necessary scripts are here -->
<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        // initializing dataTable 
        $.fn.dataTable.ext.errMode = 'none';
        const table = $('#studentsTable').DataTable({
            paging: false,
            info: false,
            lengthChange: false,
            ordering: false,
            language: { search: "Search:" },
        });

        const receiveModalEl = document.getElementById('receiveBookModal');
        const receiveModal = new bootstrap.Modal(receiveModalEl);
        let receiveStudentId = 0;

        // helper Toastify
        function toast(msg, bg='#28a745'){ Toastify({ text: msg, backgroundColor: bg, gravity:'top', position:'center' }).showToast(); }

        // receive book Modal
        $(document).on('click', '.receive-btn', function(){
            receiveStudentId = $(this).data('id') || 0;
            if(!receiveStudentId) { toast('Invalid student id','#e74c3c'); return; }
            $('#assignedBooksWrap').html('<div class="col-12 text-muted">Loading…</div>');
            $('#receiveSelectWrap').html('<div class="col-12 text-muted">Loading…</div>');
            $('#receiveActualDate').val('');
            $('#receiveAlert').hide().text('');
            $('#receiveSubmitBtn, #markLostBtn').prop('disabled', false).text(function(){ return $(this).is('#markLostBtn') ? 'Mark as Lost' : 'Receive Selected Books'; });
            $.getJSON('get_assigned_books.php', { student_id: receiveStudentId }, res=>{
                const rows = (res && res.assigned) ? res.assigned : [];
                if (rows.length === 0) {
                    $('#assignedBooksWrap').html('<div class="col-12 text-muted">No assigned books for this student.</div>');
                    $('#receiveSelectWrap').html('<div class="col-12 text-muted">No assigned books to process.</div>');
                } else {
                    let assignedHtml = '';
                    rows.forEach(r=>{
                    assignedHtml += `
                        <div class="col-lg-3 col-md-4">
                            <div class="d-flex align-items-start gap-3 p-2 border rounded">
                                <div style="width:64px;height:64px;flex:0 0 64px">
                                ${ r.image ? `<img src="../Admin/${r.image}" style="width:64px;height:64px;object-fit:contain;border-radius:6px;">` : '' }
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold">${r.book_name}</div>
                                    <div class="small text-muted">Copy code: ${r.copy_code}</div>
                                    <div class="small text-muted">Pickup: ${r.pickup_date || '-'}</div>
                                    <div class="small text-muted">Supposed: ${r.supposed_submit_date || '-'}</div>
                                    <div class="small">Status: ${r.sab_status || (r.actual_submit_date ? 'returned' : 'issued')}</div>
                                </div>
                            </div>
                        </div>`;
                    });
                    $('#assignedBooksWrap').html(assignedHtml);

                    let selectHtml = '';
                    rows.forEach(r=>{
                    const disabled = r.actual_submit_date ? 'disabled' : '';
                    selectHtml += `
                        <div class="col-lg-3 col-md-4">
                        <label class="card p-2 h-100" style="cursor:pointer; ${disabled ? 'opacity:0.6;' : '' }">
                            <div style="height:120px;overflow:hidden;">
                            ${ r.image ? `<img src="../Admin/${r.image}" style="width:100%;height:120px;object-fit:contain;border-radius:6px;">` : `<div style="width:100%;height:120px;background:#f0f0f0;border-radius:6px;display:flex;align-items:center;justify-content:center;color:#888">No Image</div>`}
                            </div>
                            <div class="card-body p-2">
                                <h6 class="mb-1">${r.book_name}</h6>
                                <p class="mb-1 small text-muted">Copy: ${r.copy_code}</p>
                                <div class="form-check">
                                    <input class="form-check-input receive-select-checkbox" type="checkbox" value="${r.assigned_id}" id="recv_chk_${r.assigned_id}" ${disabled}>
                                    <label class="form-check-label small" for="recv_chk_${r.assigned_id}">${ disabled ? 'Returned or Lost' : 'Select to process' }</label>
                                </div>
                            </div>
                        </label>
                        </div>`;
                    });
                    $('#receiveSelectWrap').html(selectHtml);
                }

                receiveModal.show();
            }).fail(()=>{
                $('#assignedBooksWrap').html('<div class="col-12 text-danger">Failed to load assigned books.</div>');
                $('#receiveSelectWrap').html('');
                receiveModal.show();
            });
        });

        // helper to disable both processing buttons
        function disableReceiveButtons(disabled, markLostText, receiveText) {
            if(typeof markLostText !== 'undefined') $('#markLostBtn').text(markLostText);
            if(typeof receiveText !== 'undefined') $('#receiveSubmitBtn').text(receiveText);
            $('#markLostBtn, #receiveSubmitBtn').prop('disabled', disabled);
        }

        // perform the actual request
        function processReceive(action) {
            const assigned = [];
            $('.receive-select-checkbox:checked').each(function(){ assigned.push($(this).val()); });
            if (assigned.length === 0) { toast('Select at least one assigned book','#e74c3c'); return; }
            const actual = $('#receiveActualDate').val();
            if (!actual) { toast('Select actual submit date & time','#e74c3c'); return; }
            if (action === 'lost') {
                disableReceiveButtons(true, 'Processing...', 'Receive Selected Books');
                $('#receiveSubmitBtn').prop('disabled', true);
            } else {
                disableReceiveButtons(true, 'Mark as Lost', 'Processing...');
                $('#markLostBtn').prop('disabled', true);
            }
            toast('Processing…', '#3498db');

            $.ajax({
                url: 'receive_books.php',
                method: 'POST',
                dataType: 'json',
                data: {
                    student_id: receiveStudentId,
                    assigned_ids: assigned,
                    action: (action === 'lost') ? 'lost' : 'submit',
                    actual_date: actual
                },
                success(res){
                    if (res && res.status === 'success') {
                        toast(res.message || 'Processed successfully');
                        receiveModal.hide();
                        if($.fn.DataTable.isDataTable('#studentsTable')) {
                            try { $('#studentsTable').DataTable().ajax && $('#studentsTable').DataTable().ajax.reload(); } catch(e){}
                        }
                    } else {
                        toast(res.message || 'Operation failed','#e74c3c');
                        if(res && res.failed && res.failed.length) {
                            $('#receiveAlert').show().html('<div class="alert alert-danger">' + res.failed.join('<br>') + '</div>');
                        }
                    }
                },
                error(xhr, status, err){toast('Server error','#e74c3c');},
                complete(){
                    $('#markLostBtn').prop('disabled', false).text('Mark as Lost');
                    $('#receiveSubmitBtn').prop('disabled', false).text('Receive Selected Books');
                }
            });
        }
        $('#receiveSubmitBtn').click(function(){ processReceive('submit'); });
        $('#markLostBtn').click(function(){ processReceive('lost'); });

        // camera setup ==============================================================================
        const cameraPermModal = new bootstrap.Modal(document.getElementById('cameraPermissionModal'));
        const scannerModal = new bootstrap.Modal(document.getElementById('scannerModal'));
        const qrResultModal = new bootstrap.Modal(document.getElementById('qrResultModal'));
        const openScanPermBtn = document.getElementById('openScanPermBtn');
        const cameraYesBtn = document.getElementById('cameraYesBtn');
        const cameraNoBtn = document.getElementById('cameraNoBtn');
        const video = document.getElementById('qrVideo');
        const canvas = document.getElementById('qrCanvas');
        const ctx = canvas.getContext('2d');
        const startBtn = document.getElementById('startScannerBtn');
        const stopBtn = document.getElementById('stopScannerBtn');
        const closeScannerBtn = document.getElementById('closeScannerBtn');
        const scanStatus = document.getElementById('scanStatus');

        let stream = null;
        let scanning = false;
        let animationFrameId = null;
        let detector = null; 
        let lastDetected = null;
        // result modal elements
        const qrResultBody = document.getElementById('qrResultBody');
        const qrReceiveBtn = document.getElementById('qrReceiveBtn');
        const qrMarkLostBtn = document.getElementById('qrMarkLostBtn');
        // open permission modal on click
        openScanPermBtn.addEventListener('click', () => {
            cameraPermModal.show();
        });
        cameraYesBtn.addEventListener('click', async () => {
            cameraPermModal.hide();
            scannerModal.show();
            await startCameraAndScanner();
        });
        cameraNoBtn.addEventListener('click', () => {
            cameraPermModal.hide();
        });
        // helper: start camera
        async function startCameraAndScanner() {
            try {
                await stopCamera();
                stream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' }, audio: false });
                video.srcObject = stream;
                await video.play();
                canvas.width = video.videoWidth || 640;
                canvas.height = video.videoHeight || 480;
                if ('BarcodeDetector' in window) {
                    try {
                        detector = new BarcodeDetector({ formats: ['qr_code'] });
                    } catch (e) {
                        detector = null;
                    }
                } else detector = null;
                scanning = true;
                startBtn.disabled = true;
                stopBtn.disabled = false;
                scanStatus.textContent = 'Scanning…';
                runScannerLoop();
            } catch (err) {
                console.error('Camera error', err);
                toast('Unable to access camera. Check permissions or try another device.', '#e74c3c');
                scanStatus.textContent = 'Camera error';
                startBtn.disabled = false;
                stopBtn.disabled = true;
            }
        }
        // helper: stop camera & loop
        async function stopCamera() {
            scanning = false;
            if (animationFrameId) {
                cancelAnimationFrame(animationFrameId);
                animationFrameId = null;
            }
            if (video && video.srcObject) {
                const tracks = video.srcObject.getTracks();
                tracks.forEach(t => t.stop());
                video.srcObject = null;
            }
            if (stream) {
                stream.getTracks().forEach(t => t.stop());
            }
            stream = null;
            detector = null;
            startBtn.disabled = false;
            stopBtn.disabled = true;
            scanStatus.textContent = 'Stopped';
        }
        // scanner loop - draws to canvas and decodes
        function runScannerLoop() {
            if (!scanning) return;
            try {
                if (video.videoWidth) {
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                }
                ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                if (detector) {
                    createImageBitmap(canvas).then(bitmap => {
                        detector.detect(bitmap).then(barcodes => {
                            if (barcodes && barcodes.length) {
                                const code = barcodes[0].rawValue || barcodes[0].rawData || null;
                                if (code) handleDetectedCode(code);
                            } else {
                                animationFrameId = requestAnimationFrame(runScannerLoop);
                            }
                        }).catch(err => {
                            decodeWithJsQR();
                        });
                    }).catch(err => {
                        decodeWithJsQR();
                    });
                } else {
                    decodeWithJsQR();
                }
            } catch (e) {
                console.error(e);
                animationFrameId = requestAnimationFrame(runScannerLoop);
            }
        }
        function decodeWithJsQR() {
            try {
                const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
                const code = jsQR(imageData.data, imageData.width, imageData.height);
                if (code && code.data) {
                    handleDetectedCode(code.data);
                } else {
                    animationFrameId = requestAnimationFrame(runScannerLoop);
                }
            } catch (err) {
                console.error('jsQR error', err);
                animationFrameId = requestAnimationFrame(runScannerLoop);
            }
        }
        // called when a code is detected
        function handleDetectedCode(decoded) {
            if (!decoded) {
                animationFrameId = requestAnimationFrame(runScannerLoop);
                return;
            }
            if (lastDetected === decoded) return;
            lastDetected = decoded;
            scanning = false;
            stopBtn.disabled = true;
            scanStatus.textContent = 'Detected: ' + decoded;
            toast('QR detected: ' + decoded, '#3498db');
            stopCamera().then(() => {
                scannerModal.hide();
                lookupAssignment(decoded);
            });
        }
        // start/stop button handlers
        startBtn.addEventListener('click', async () => { await startCameraAndScanner(); });
        stopBtn.addEventListener('click', async () => { await stopCamera(); scannerModal.hide(); });
        closeScannerBtn.addEventListener('click', async () => { await stopCamera(); });
        function lookupAssignment(copyCode) {
            $('#qrResultBody').html('<div class="text-center text-muted">Fetching assignment…</div>');
            qrResultModal.show();
            $.getJSON('get_assignment_by_copy.php', { copy_code: copyCode }, res => {
                if (!res) {
                    $('#qrResultBody').html('<div class="text-danger">Server error</div>');
                    return;
                }
                if (res.status !== 'success') {
                    $('#qrResultBody').html('<div class="text-center text-muted">No active assignment found for this code.</div>');
                    toast(res.message || 'No active assignment found for this code', '#e74c3c');
                    return;
                }
                const d = res.data;
                const html = `
                    <div class="d-flex gap-3 align-items-center">
                    <div style="width:96px;height:96px;flex:0 0 96px">
                        ${d.image ? `<img src="${escapeHtml(d.image)}" style="width:96px;height:96px;object-fit:cover;border-radius:8px">` : ''}
                    </div>
                    <div class="flex-grow-1">
                        <div class="fw-bold">${escapeHtml(d.book_name)}</div>
                        <div class="small text-muted">Copy code: ${escapeHtml(d.copy_code)}</div>
                        <hr/>
                        <div class="fw-bold">${escapeHtml(d.student_name)}</div>
                        <div class="small text-muted">Email: ${escapeHtml(d.student_email)} • Phone: ${escapeHtml(d.student_phone)}</div>
                        <div class="small mt-1">Pickup: ${d.pickup_date || '-'} • Due: ${d.supposed_submit_date || '-'}</div>
                        <div class="small mt-1">Assigned id: <code>${d.assigned_id}</code></div>
                    </div>
                    </div>`;
                $('#qrResultBody').html(html);
                qrReceiveBtn.onclick = function() {
                    processSingleAssigned(d.assigned_id, 'submit');
                };
                qrMarkLostBtn.onclick = function() {
                    if (!confirm('Mark this copy as LOST? This will notify the parent via email.')) return;
                    processSingleAssigned(d.assigned_id, 'lost');
                };
            }).fail(()=> {
                $('#qrResultBody').html('<div class="text-danger">Failed to fetch assignment. Server error.</div>');
                toast('Failed to fetch assignment', '#e74c3c');
            });
        }
        // helper to escape html
        function escapeHtml(s){ if(!s) return ''; return String(s).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;'); }
        // reuse same receive_books.php endpoint — process single assigned id
        function processSingleAssigned(assignedId, action) {
            if (!assignedId) { toast('Invalid assigned id','#e74c3c'); return; }
            const dt = new Date().toISOString().slice(0,16); 
            const userDate = prompt('Enter actual submit date/time (YYYY-MM-DD HH:MM) or leave blank for now. Example: 2025-08-01 14:30', '');
            if (userDate === null) return; 
            let actualDate = userDate.trim();
            if (!actualDate) {
                const now = new Date();
                const pad = n => (n<10?'0':'')+n;
                actualDate = now.getFullYear() + '-' + pad(now.getMonth()+1) + '-' + pad(now.getDate()) + ' ' + pad(now.getHours()) + ':' + pad(now.getMinutes()) + ':00';
            }
            // disable buttons
            qrReceiveBtn.disabled = true;
            qrMarkLostBtn.disabled = true;
            toast('Processing…', '#3498db');
            $.ajax({
                url: 'receive_books.php',
                method: 'POST',
                dataType: 'json',
                data: {
                    student_id: 0, 
                    assigned_ids: [assignedId],
                    action: (action === 'lost') ? 'lost' : 'submit',
                    actual_date: actualDate
                },
                success(res) {
                    if (res && res.status === 'success') {
                        toast(res.message || 'Processed successfully');
                        qrResultModal.hide();
                        try { loadStudents(); } catch(e) { if (window.studentsTable && studentsTable.ajax) studentsTable.ajax.reload(); }
                    } else {
                        toast(res.message || 'Failed operation', '#e74c3c');
                    }
                },
                error() {
                    toast('Server error', '#e74c3c');
                },
                complete() {
                    qrReceiveBtn.disabled = false;
                    qrMarkLostBtn.disabled = false;
                }
            });
        }

        // load classes
        function loadClasses(deptId) {
            $('#filterClass').prop('disabled', !deptId).html('<option>Loading…</option>');
            $.getJSON('get_classes.php', { dept_id: deptId }, classes => {
                let opts = '<option value="">Select Class</option>';
                classes.forEach(c => opts += `<option value="${c.id}">${c.name}</option>`);
                $('#filterClass').html(opts).prop('disabled', false);
                $('#filterSection').html('<option>Select Section</option>').prop('disabled', true);
            });
        }

        // load sections
        function loadSections(classId) {
            $('#filterSection').prop('disabled', !classId).html('<option>Loading…</option>');
            $.getJSON('get_sections.php', { class_id: classId }, secs => {
                let opts = '<option value="">Select Section</option>';
                secs.forEach(s => opts += `<option value="${s.id}">${s.name}</option>`);
                $('#filterSection').html(opts).prop('disabled', false);
            });
        }

        // Fetch & render students
        function loadStudents() {
            const dept = $('#filterDept').val(),
                cls  = $('#filterClass').val(),
                sec  = $('#filterSection').val();
            if (!dept || !cls || !sec) {
                table.clear().draw();
                return;
            }
            $.getJSON('get_students.php', { dept_id: dept, class_id: cls, section_id: sec }, data => {
                table.clear();
                data.forEach(std => {
                    const rollCol = `<span class="text-center fw-bold text-muted">${std.roll_no}</span>`;
                    const nameCol = `
                    <div class="d-flex align-items-center">
                        ${std.image ? `<img src="../Student/${std.image}" class="rounded-circle me-2" style="width:40px;height:40px;object-fit:cover;">` : ''}
                        <div class="d-flex align-items-start justify-content-start flex-column">
                            <span class="fw-bold text-primary">${std.name}</span>
                            <span class="fw-bold">D.O.B: <span class="text-primary">${std.dob}</span> • Age: <span class="text-primary">${std.age}</span></span>
                            <span class ="fw-bold">UID: <span class="text-primary">${std.student_uid}</span></span>
                        </div>
                    </div>`;
                    const contactCol = `
                    <div class="d-flex flex-column text-start">
                        <span class="fw-bold">Email: <a href="mailto:${std.email}" class="text-primary">${std.email}</a></span>
                        <span class="fw-bold">Phone: <a href="tel:${std.phone}" class="text-primary">${std.phone}</a></span>
                    </div>`;
                    const sectionText = std.section ?? '-';
                    const classCol = `
                    <div class="d-flex flex-column text-start">
                        <span class="fw-bold">Class: <span class="text-primary">${std.department}</span></span>
                        <span class="fw-bold">Department: <span class="text-primary">${std.class}</span></span>
                        <span class="fw-bold">Section: <span class="text-primary">${sectionText}</span></span>
                    </div>`;
                    const actionBtn = `<button class="btn btn-sm btn-secondary receive-btn" data-id="${std.id}"><i class="bi bi-book me-1"></i> Receive Book</button>`;

                    table.row.add([rollCol, nameCol, contactCol, classCol, actionBtn]);
                });
                table.draw();
            });
        }

        // Event bindings
        $('#filterDept').change(function() {
            loadClasses(this.value);
            loadStudents();  
        });
        $('#filterClass').change(function() {
            loadSections(this.value);
            loadStudents();  
        });
        $('#filterSection').change(loadStudents);

    });
</script>
<?php include "footerlink.php"; ?>