<?php
header('Content-Type: application/json');
session_start();
if (empty($_SESSION['id'])) {
  echo json_encode(['status'=>'error','message'=>'Not logged in']);
  exit;
}
require 'config.php';

$title   = trim($_POST['title']   ?? '');
$content = trim($_POST['content'] ?? '');
$tid     = $_SESSION['id'];

if (!$title || !$content) {
  echo json_encode(['status'=>'error','message'=>'All fields required']);
  exit;
}

$prov_doc_path = '';
$uploadDir = '../api/uploads/leave/';   
if (!is_dir($uploadDir)) {
  mkdir($uploadDir, 0755, true);
}
if (isset($_FILES['prov_doc']) && $_FILES['prov_doc']['error'] === UPLOAD_ERR_OK) {
  $filename   = time() . '_' . basename($_FILES['prov_doc']['name']);
  $targetPath = $uploadDir . $filename;
  if (move_uploaded_file($_FILES['prov_doc']['tmp_name'], $targetPath)) {
    $prov_doc_path = '/api/uploads/leave/' . $filename;
  }
}

try {
  $stmt = $pdo->prepare("INSERT INTO teacher_posted_application (teacher_id, created_at, title, content, current_status, prove_doc) VALUES (:tid, NOW(), :title, :content, 'Pending', :prov_doc)");
  $stmt->execute([':tid' => $tid, ':title' => $title,':content' => $content, ':prov_doc' => $prov_doc_path]);

  echo json_encode(['status'=>'success']);
} catch (Exception $e) {
  echo json_encode([
    'status'  => 'error',
    'message' => 'DB Error: ' . $e->getMessage()
  ]);
  exit;
} ?>