<?php
require 'config.php';
header('Content-Type: application/json');
session_start();

$id          = (int)($_POST['id']            ?? 0);
$dept_id     = (int)($_POST['dept_id']       ?? 0);
$class_id    = (int)($_POST['class_id']      ?? 0);
$section_id  = (int)($_POST['section_id']    ?? 0);
$exam_name   = trim($_POST['exam_name']      ?? '');
$total_marks = (int)($_POST['total_marks']   ?? 0);
$exam_dt     = trim($_POST['exam_datetime']  ?? '');
$subjects    = json_decode($_POST['subjects'] ?? '[]', true);

if (!$id||!$dept_id||!$class_id||!$exam_name||!$total_marks||!$exam_dt||!is_array($subjects)) {
  echo json_encode(['success'=>false,'message'=>'Missing required fields']);
  exit;
}

$subs_json = json_encode($subjects);
try {
  $stmt = $pdo->prepare("UPDATE class_exams SET dept_id = :dep, class_id = :cls, section_id = :sec, exam_name = :name, total_marks = :marks, exam_datetime= :dt, subjects = :subs WHERE id = :id");
  $stmt->execute(['dep'=> $dept_id, 'cls'=> $class_id, 'sec'=> $section_id, 'name'=> $exam_name, 'marks'=> $total_marks, 'dt'=> $exam_dt, 'subs'=> $subs_json, 'id'=> $id]);
  echo json_encode(['success'=>true,'message'=>'Exam updated']);
} catch (PDOException $e) {
  error_log("UpdateExam Error: ".$e->getMessage());
  echo json_encode(['success'=>false,'message'=>'DB error']);
} ?>