<?php
header('Content-Type: application/json; charset=utf-8');

try {
    include 'config.php';
} catch (Exception $e) {
    echo json_encode(['status' => false, 'message' => 'Server config error.']);
    exit;
}

function json_resp($status, $msg) {
    echo json_encode(['status' => $status, 'message' => $msg]);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_resp(false, 'Invalid request method.');
}

$teacher_id = isset($_POST['teacher_id']) ? intval($_POST['teacher_id']) : 0;
if ($teacher_id <= 0) json_resp(false, 'Invalid teacher ID.');

$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$address = isset($_POST['address']) ? trim($_POST['address']) : '';
$university = isset($_POST['university']) ? trim($_POST['university']) : '';
$college = isset($_POST['college']) ? trim($_POST['college']) : '';
$degree = isset($_POST['degree']) ? trim($_POST['degree']) : '';
$duration = isset($_POST['duration']) ? trim($_POST['duration']) : '';
$city = isset($_POST['city']) ? trim($_POST['city']) : '';
$current_image = isset($_POST['current_image']) ? trim($_POST['current_image']) : '';

if ($name === '') json_resp(false, 'Name is required.');
if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) json_resp(false, 'Valid email is required.');

$dbImagePath = $current_image; 
$allowed_exts = ['jpg','jpeg','png','gif'];
$maxFileSize = 1 * 1024 * 1024; 

if (isset($_FILES['image']) && isset($_FILES['image']['tmp_name']) && $_FILES['image']['tmp_name'] !== '') {
    $file = $_FILES['image'];

    if ($file['error'] !== UPLOAD_ERR_OK) {
        json_resp(false, 'File upload error code: ' . $file['error']);
    }
    if ($file['size'] > $maxFileSize) {
        json_resp(false, 'Image too large. Max 5 MB allowed.');
    }

    $finfo = pathinfo($file['name']);
    $ext = strtolower($finfo['extension'] ?? '');

    if (!in_array($ext, $allowed_exts)) {
        json_resp(false, 'Only JPG, JPEG, PNG, GIF images are allowed.');
    }

    $uploadRelativeDir = 'uploads/teacher/'; 
    $serverRelativeDir = '../Admin/' . $uploadRelativeDir; 

    if (!is_dir($serverRelativeDir)) {
        if (!mkdir($serverRelativeDir, 0755, true)) {
            json_resp(false, 'Failed to create upload directory.');
        }
    }
    $filename = time() . '_' . uniqid() . '.' . $ext;
    $targetPath = $serverRelativeDir . $filename; 
    $dbImagePath = $uploadRelativeDir . $filename; 

    if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
        json_resp(false, 'Failed to save uploaded file.');
    }
    @chmod($targetPath, 0644);
} else {}

try {
    $sql = "UPDATE teachers SET name = :name, phone = :phone, email = :email, address = :address, university = :university, college = :college, degree = :degree, duration = :duration, city = :city, image = :image WHERE id = :id LIMIT 1";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name' => $name,
        ':phone' => $phone,
        ':email' => $email,
        ':address' => $address,
        ':university' => $university,
        ':college' => $college,
        ':degree' => $degree,
        ':duration' => $duration,
        ':city' => $city,
        ':image' => $dbImagePath,
        ':id' => $teacher_id
    ]);

    json_resp(true, 'Profile updated successfully.');
} catch (PDOException $e) {
    if (!empty($dbImagePath) && isset($targetPath) && file_exists($targetPath)) {
        @unlink($targetPath);
    }
    json_resp(false, 'Database error: ' . $e->getMessage());
} ?>