<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include "configDealer.php";

try {
    $name   = trim($_POST['book']   ?? '');
    $author = trim($_POST['author'] ?? '');
    $type   = trim($_POST['type']   ?? '');
    $stock  = intval($_POST['stock'] ?? 0);
    $des    = trim($_POST['des']    ?? '');

    if (!$name || !$author || !$type || $stock < 1 || empty($_FILES['image']['tmp_name'])) {
        throw new Exception('All required fields must be filled and stock ≥1.');
    }
    
    $check_q = "SELECT id FROM books WHERE name = '{$name}' AND author = '{$author}'";
    $check_r = mysqli_query($conn, $check_q);
    if (mysqli_num_rows($check_r) > 0)
    {
        echo json_encode([
            'status'  => false,
            'message' => "Book already exists"
        ]);
    }
    
    $stmt = mysqli_prepare($conn, "SELECT id FROM book_category WHERE name = ?");
    mysqli_stmt_bind_param($stmt, "s", $type);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $cat);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if (!$cat) {
        $stmt = mysqli_prepare($conn, "INSERT INTO book_category (name) VALUES (?)");
        mysqli_stmt_bind_param($stmt, "s", $type);
        mysqli_stmt_execute($stmt);
        $cat = mysqli_insert_id($conn);
        mysqli_stmt_close($stmt);
    }

    // Book image upload
    $bookDir = '../Admin/uploads/books/';
    if (!is_dir($bookDir) && !mkdir($bookDir, 0777, true)) {
        throw new Exception("Cannot create directory: $bookDir");
    }
    $img      = $_FILES['image'];
    $ext      = strtolower(pathinfo($img['name'], PATHINFO_EXTENSION));
    $bookImg  = uniqid('book_', true) . '.' . $ext;
    $bookDest = $bookDir . $bookImg;
    if (!is_uploaded_file($img['tmp_name']) || !move_uploaded_file($img['tmp_name'], $bookDest)) {
        throw new Exception('Book cover upload failed.');
    }

    // Insert book
    $stmt = mysqli_prepare($conn, "INSERT INTO books (cat_id, name, author, stock, des, image) VALUES (?, ?, ?, ?, ?, ?)");
    $bookImgPath = 'uploads/books/' . $bookImg;
    mysqli_stmt_bind_param($stmt, "ississ", $cat, $name, $author, $stock, $des, $bookImgPath);
    mysqli_stmt_execute($stmt);
    $book_id = mysqli_insert_id($conn);
    mysqli_stmt_close($stmt);

    // QR code directory
    $qrDir = '../Admin/uploads/book_qr/';
    if (!is_dir($qrDir) && !mkdir($qrDir, 0777, true)) {
        throw new Exception("Cannot create directory: $qrDir");
    }

    for ($i = 1; $i <= $stock; $i++) {
        $copyCode = $book_id . '-' . str_pad($i, 4, '0', STR_PAD_LEFT);
        $qrFile = "qr_{$copyCode}.png";
        $qrPath = $qrDir . $qrFile;

        $apiUrl = 'https://api.qrserver.com/v1/create-qr-code/' . '?data=' . urlencode($copyCode) . '&size=200x200';
        $ch = curl_init($apiUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT        => 10,
        ]);
        $qrData = curl_exec($ch);
        $err    = curl_error($ch);
        curl_close($ch);

        if ($err || !$qrData) {
            throw new Exception("Failed to generate QR for {$copyCode}: {$err}");
        }
        file_put_contents($qrPath, $qrData);

        // Insert book copy
        $codeImgPath = 'uploads/book_qr/' . $qrFile;
        $stmt = mysqli_prepare($conn, "INSERT INTO book_copies (book_id, copy_code, code_type, code_image) VALUES (?, ?, 'QR', ?)");
        mysqli_stmt_bind_param($stmt, "iss", $book_id, $copyCode, $codeImgPath);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    echo json_encode([
        'status'  => true,
        'message' => "Book + {$stock} QR codes saved!"
    ]);

} catch (Exception $e) {
    // error_log("add_book.php Error: " . $e->getMessage());
    echo json_encode([
        'status'  => false,
        'message' => $e->getMessage()
    ]);
}

mysqli_close($conn);
?>
