<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$que = "
SELECT 
    d.id AS dept_id,
    d.name AS dept_name,
    c.id AS class_id,
    c.name AS class_name,
    s.id AS section_id,
    s.name AS section_name
FROM 
    departments d
LEFT JOIN 
    classes c ON c.department_id = d.id
LEFT JOIN 
    sections s ON s.class_id = c.id
ORDER BY 
    d.id ASC, c.id ASC, s.id ASC
";

$res = mysqli_query($conn, $que);

$output = [];

if ($res && mysqli_num_rows($res) > 0) {
    while ($row = mysqli_fetch_assoc($res)) {
        $dept_id = $row['dept_id'];
        $class_id = $row['class_id'];
        $section_id = $row['section_id'];

        // Initialize department if not set
        if (!isset($output[$dept_id])) {
            $output[$dept_id] = [
                'dept_id' => (int)$dept_id,
                'dept_name' => $row['dept_name'],
                'classes' => []
            ];
        }

        // Initialize class under department if class_id exists and not set
        if (!empty($class_id) && !isset($output[$dept_id]['classes'][$class_id])) {
            $output[$dept_id]['classes'][$class_id] = [
                'class_id' => (int)$class_id,
                'class_name' => $row['class_name'],
                'sections' => []
            ];
        }

        // Add section under class if section_id exists
        if (!empty($class_id) && !empty($section_id)) {
            $output[$dept_id]['classes'][$class_id]['sections'][] = [
                'section_id' => (int)$section_id,
                'section_name' => $row['section_name']
            ];
        }
    }

    // Re-index arrays (convert assoc arrays to indexed arrays for JSON)
    $output = array_values(array_map(function($dept) {
        $dept['classes'] = array_values($dept['classes']);
        foreach ($dept['classes'] as &$class) {
            $class['sections'] = array_values($class['sections']);
        }
        return $dept;
    }, $output));

    echo json_encode([
        'status' => true,
        'data' => $output
    ]);
} else {
    echo json_encode([
        'status' => false,
        'message' => 'No data found'
    ]);
}

mysqli_close($conn);
?>
