<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

// Validate teacher_id parameter
if (empty($_GET['teacher_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: teacher_id";
    echo json_encode($response);
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));

// Get current weekday and time
date_default_timezone_set("Asia/Kolkata"); // change to your timezone
$current_day = date("l"); // e.g., Monday
$current_time = date("H:i:s"); 

// Fetch all assignments for the teacher
$get_assignments_q = "SELECT * FROM routine_assignments WHERE teacher_id = '{$teacher_id}'";
$get_assignments_r = mysqli_query($conn, $get_assignments_q);

if ($get_assignments_r && mysqli_num_rows($get_assignments_r) > 0) {
    $routine = [];
    $current_class = null;
    $upcoming_class = null;

    while ($assignment = mysqli_fetch_assoc($get_assignments_r)) {
        $slot_id = $assignment['slot_id'];
        $subject = $assignment['subject'];

        // Get details of the routine and slot including dept, class, section names
        $get_slot_q = "
            SELECT 
                r.id AS routine_id,
                rs.id AS slot_id,
                rs.weekday,
                rs.slot_order,
                rs.start_time,
                rs.end_time,
                rs.is_tiffin_break,
                d.name AS dept_name,
                c.name AS class_name,
                s.name AS section_name
            FROM 
                routines r
            LEFT JOIN 
                routine_slots rs ON rs.routine_id = r.id
            LEFT JOIN 
                departments d ON r.department_id = d.id
            LEFT JOIN 
                classes c ON r.class_id = c.id
            LEFT JOIN 
                sections s ON r.section_id = s.id
            WHERE 
                rs.id = '{$slot_id}'
        ";
        $get_slot_r = mysqli_query($conn, $get_slot_q);

        if ($get_slot_r && mysqli_num_rows($get_slot_r) > 0) {
            $slot = mysqli_fetch_assoc($get_slot_r);

            $day = $slot['weekday'];
            if (!isset($routine[$day])) {
                $routine[$day] = [
                    'weekday' => $day,
                    'slots' => []
                ];
            }

            $slot_data = [
                'slot_id' => (int)$slot['slot_id'],
                'start_time' => $slot['start_time'],
                'end_time' => $slot['end_time'],
                'subject' => $subject,
                'is_tiffin_break' => (bool)$slot['is_tiffin_break'],
                'dept_name' => $slot['dept_name'],
                'class_name' => $slot['class_name'],
                'section_name' => $slot['section_name']
            ];

            $routine[$day]['slots'][] = $slot_data;

            // Check if today and compare times
            if ($day == $current_day) {
                if ($current_time >= $slot['start_time'] && $current_time <= $slot['end_time']) {
                    $current_class = $slot_data;
                } elseif ($current_time < $slot['start_time']) {
                    if ($upcoming_class === null || $slot['start_time'] < $upcoming_class['start_time']) {
                        $upcoming_class = $slot_data;
                    }
                }
            }
        }
    }

    // Sort weekdays
    $weekdays_order = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
    $sorted_routine = [];
    foreach ($weekdays_order as $day) {
        if (isset($routine[$day])) {
            $sorted_routine[] = $routine[$day];
        }
    }

    $response['status'] = true;
    // $response['data'] = $sorted_routine;
    $response['current_class'] = $current_class;
    $response['upcoming_class'] = $upcoming_class;

} else {
    $response['status'] = false;
    $response['message'] = "No routine assignments found for the given teacher_id.";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
