<?php
// fetch_logs.php
header('Content-Type: application/json; charset=utf-8');
require_once 'config.php';

$imei = isset($_GET['imei']) ? $mysqli->real_escape_string($_GET['imei']) : null;
$from = isset($_GET['from']) ? $mysqli->real_escape_string($_GET['from']) : null; // format YYYY-MM-DD or YYYY-MM-DD HH:MM:SS
$to = isset($_GET['to']) ? $mysqli->real_escape_string($_GET['to']) : null;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 100;
$page = isset($_GET['page']) ? max(1,intval($_GET['page'])) : 1;
$offset = ($page-1)*$limit;

$where = [];
if ($imei) $where[] = "imei = '{$imei}'";
if ($from) $where[] = "datetime >= '{$from}'";
if ($to) $where[] = "datetime <= '{$to}'";
$where_sql = $where ? 'WHERE '. implode(' AND ', $where) : '';

$totalRes = $mysqli->query("SELECT COUNT(*) AS cnt FROM tracker_locations {$where_sql}");
$total = 0;
if ($totalRes) {
    $r = $totalRes->fetch_assoc();
    $total = intval($r['cnt']);
}

$sql = "SELECT id, imei, datetime, latitude, longitude, speed_kmh, course, mcc, mnc, lac, cellid, raw_hex, created_at
FROM tracker_locations
{$where_sql}
ORDER BY datetime DESC
LIMIT {$limit} OFFSET {$offset}";

$res = $mysqli->query($sql);
$rows = [];
if ($res) {
    while ($row = $res->fetch_assoc()) $rows[] = $row;
}

echo json_encode([
    'status'=>'ok',
    'total'=>$total,
    'page'=>$page,
    'limit'=>$limit,
    'count'=>count($rows),
    'data'=>$rows
]);
