<?php
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include 'configDealer.php';

$response = [];

if (empty($_GET['teacher_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: teacher_id";
    echo json_encode($response);
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, trim($_GET['teacher_id']));

$data = [];

$get_letter_q = "
    SELECT 
        *
    FROM 
        teacher_posted_application
        WHERE teacher_id = '{$teacher_id}'
    ORDER BY 
        id DESC
";

$get_letter_r = mysqli_query($conn, $get_letter_q);

if ($get_letter_r && mysqli_num_rows($get_letter_r) > 0) {
    while ($row = mysqli_fetch_assoc($get_letter_r)) {
        $data[] = [
            'letter_id' => $row['id'],
            'title' => $row['title'],
            'content' => $row['content'],
            'created_at' => $row['created_at'],
            'current_status' => $row['current_status'],
            'approve_reject_time' => $row['approve_reject_time'],
            'prove_doc' => $row['prove_doc'],
            // 'class_name' => $row['class_name'],
            // 'section_name' => $row['section_name']
        ];
    }

    $response['status'] = true;
    $response['message'] = "Letters fetched successfully";
    $response['data'] = $data;
} else {
    $response['status'] = false;
    $response['message'] = "No letters found.";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
