<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include "configDealer.php";

date_default_timezone_set('Asia/Kolkata');
try {
    $student_id   = trim($_POST['student_id']   ?? '');
    $book_id = trim($_POST['book_id'] ?? '');
    $pickup_date  = date("Y-m-d H:i:s");
    $supposed_submit_date  = trim($_POST['supposed_submit_date'] ?? '');

    if (!$student_id || !$book_id || !$supposed_submit_date) {
        throw new Exception('All required fields must be filled.');
    }

    $desired_sts = 'available';
    $stmt = mysqli_prepare($conn, "SELECT copy_code FROM book_copies WHERE book_id = ? AND status = ? ORDER BY id LIMIT 1");
    mysqli_stmt_bind_param($stmt, "ss", $book_id, $desired_sts);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $cat);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($cat) {
        // echo $cat;
        $check_book_issued_by_this_student_q = "SELECT id FROM student_assigned_books WHERE student_id = '{$student_id}' AND book_id = '{$cat}' AND (actual_submit_date != '' OR actual_submit_date IS NULL)";
        $check_book_issued_by_this_student_R = mysqli_query($conn, $check_book_issued_by_this_student_q);
        if (mysqli_num_rows($check_book_issued_by_this_student_R) > 0)
        {
            echo json_encode([
                'status'  => false,
                'message' => "This Book has already been issued to this student"
            ]);
        }
        $stmt = mysqli_prepare($conn, "INSERT INTO student_assigned_books (student_id, book_id, pickup_date, supposed_submit_date) VALUES (?, ?, ?, ?)");
        mysqli_stmt_bind_param($stmt, "ssss", $student_id, $cat, $pickup_date, $supposed_submit_date);
        mysqli_stmt_execute($stmt);
        // $cat = mysqli_insert_id($conn);
        mysqli_stmt_close($stmt);
        
        // echo $cat;
        $upd_avl_q = "UPDATE book_copies SET status = 'issued' WHERE copy_code = '{$cat}'";
        $upd_avl_r = mysqli_query($conn, $upd_avl_q);
    }
    else
    {
        echo json_encode([
            'status'  => false,
            'message' => "Book is not available rightnow!"
        ]);
        mysqli_close($conn);
        exit();
    }

    echo json_encode([
        'status'  => true,
        'message' => "Book issued successfully"
    ]);

} catch (Exception $e) {
    error_log("add_book.php Error: " . $e->getMessage());
    echo json_encode([
        'status'  => false,
        'message' => $e->getMessage()
    ]);
}

mysqli_close($conn);
?>
