<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

date_default_timezone_set('Asia/Kolkata');
// include mysqli connection
include "configDealer.php"; // gives $conn (mysqli connection)

// Collect POST data
$studentId   = (int)($_POST['student_id'] ?? 0);
$title       = trim($_POST['title'] ?? '');
$description = trim($_POST['description'] ?? '');
$created_at  = date('Y-m-d H:i:s');

// Validate required fields
if (!$studentId || !$title || !$description) {
    echo json_encode(['status'=>false,'message'=>'All fields except document are required']);
    exit;
}

// File upload
$prov_doc_path = '';
$uploadDir = 'uploads/reports/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}
if (!empty($_FILES['prov_doc']['name']) && $_FILES['prov_doc'][false] === UPLOAD_ERR_OK) {
    $fname = time() . '_' . basename($_FILES['prov_doc']['name']);
    $target = $uploadDir . $fname;
    if (move_uploaded_file($_FILES['prov_doc']['tmp_name'], $target)) {
        $prov_doc_path = '/api/uploads/reports/' . $fname;
    }
}

// Insert into DB
$sql = "INSERT INTO student_reports (created_at, title, description, prov_doc, student_id) 
        VALUES (?, ?, ?, ?, ?)";
$stmt = mysqli_prepare($conn, $sql);

if ($stmt) {
    mysqli_stmt_bind_param($stmt, "ssssi", $created_at, $title, $description, $prov_doc_path, $studentId);
    if (mysqli_stmt_execute($stmt)) {
        echo json_encode(['status'=>true,'message'=>'Report submitted']);
    } else {
        echo json_encode(['status'=>false,'message'=>'DB Error: '.mysqli_error($conn)]);
    }
    mysqli_stmt_close($stmt);
} else {
    echo json_encode(['status'=>false,'message'=>'Prepare failed: '.mysqli_error($conn)]);
}

mysqli_close($conn);
?>
