<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

include('../configDealer.php');

// Get query params
$deptName    = trim($_GET['department_name'] ?? '');
$className   = trim($_GET['class_name'] ?? '');
$sectionName = trim($_GET['section_name'] ?? '');

// Lookup IDs (assuming you’re getting IDs based on names)
function getIdByName($conn, $table, $name) {
    $id = 0;
    $stmt = mysqli_prepare($conn, "SELECT id FROM $table WHERE name = ?");
    mysqli_stmt_bind_param($stmt, 's', $name);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $id);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
    return $id ?: null;
}

$deptId    = 9;
$classId   = 17;
$sectionId = 0;

// Build WHERE clause
$where = [];
$params = [];
$types = '';

if ($deptId)    { $where[] = 'r.department_id = ?'; $params[] = $deptId; $types .= 'i'; }
if ($classId)   { $where[] = 'r.class_id = ?';      $params[] = $classId; $types .= 'i'; }
if ($sectionId) { $where[] = 'r.section_id = ?';    $params[] = $sectionId; $types .= 'i'; }

$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// Fetch routines
$sql = "
    SELECT r.*,
           d.name AS dept_name,
           COALESCE(c.name, '—') AS class_name,
           COALESCE(s.name, '—') AS section_name
      FROM routines r
      JOIN departments d ON d.id = r.department_id
 LEFT JOIN classes c ON c.id = r.class_id
 LEFT JOIN sections s ON s.id = r.section_id
  $where_sql
  ORDER BY d.name, c.name, s.name
";

$stmt = mysqli_prepare($conn, $sql);
if ($params) {
    mysqli_stmt_bind_param($stmt, $types, ...$params);
}
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$routines = [];
while ($rt = mysqli_fetch_assoc($result)) {
    // Fetch slots for this routine
    $slots = [];
    $assignments = [];

    $routineId = $rt['id'];

    $slot_sql = "
        SELECT id, weekday, slot_order, start_time, end_time, is_tiffin_break
        FROM routine_slots
        WHERE routine_id = ?
        ORDER BY FIELD(weekday, 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'),
                 slot_order
    ";
    $slot_stmt = mysqli_prepare($conn, $slot_sql);
    mysqli_stmt_bind_param($slot_stmt, 'i', $routineId);
    mysqli_stmt_execute($slot_stmt);
    $slot_result = mysqli_stmt_get_result($slot_stmt);

    while ($slot = mysqli_fetch_assoc($slot_result)) {
        $slots[] = $slot;
    }
    mysqli_stmt_close($slot_stmt);

    // Fetch assignments for this routine
    $assign_sql = "
        SELECT ra.slot_id, ra.subject, t.name AS teacher
        FROM routine_assignments ra
        JOIN teachers t ON t.id = ra.teacher_id
        WHERE ra.slot_id IN (
            SELECT id FROM routine_slots WHERE routine_id = ?
        )
    ";
    $assign_stmt = mysqli_prepare($conn, $assign_sql);
    mysqli_stmt_bind_param($assign_stmt, 'i', $routineId);
    mysqli_stmt_execute($assign_stmt);
    $assign_result = mysqli_stmt_get_result($assign_stmt);

    while ($row = mysqli_fetch_assoc($assign_result)) {
        $assignments[$row['slot_id']] = [
            'subject' => $row['subject'],
            'teacher' => $row['teacher']
        ];
    }
    mysqli_stmt_close($assign_stmt);

    $routines[] = [
        'id'           => $rt['id'],
        'department'   => $rt['dept_name'],
        'class'        => $rt['class_name'],
        'section'      => $rt['section_name'],
        'slots_before_tiffin' => $rt['slots_before_tiffin'],
        'slots_after_tiffin'  => $rt['slots_after_tiffin'],
        'slots'        => $slots,
        'assignments'  => $assignments
    ];
}

mysqli_stmt_close($stmt);
mysqli_close($conn);

// Return JSON
echo json_encode([
    'status'   => true,
    'routines' => $routines
]);
exit;
?>
