<?php
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include '../configDealer.php';

$response = [];

if (empty($_POST['student_id'])) {
    $response['status'] = false;
    $response['message'] = "Missing required parameter: student_id";
    echo json_encode($response);
    exit();
}

$student_id = mysqli_real_escape_string($conn, trim($_POST['student_id']));

$data = [];

$get_letter_q = "
    SELECT 
        *
    FROM 
        student_assigned_books
        WHERE student_id = '{$student_id}'
    ORDER BY 
        id DESC
";

$get_letter_r = mysqli_query($conn, $get_letter_q);

if ($get_letter_r && mysqli_num_rows($get_letter_r) > 0) {
    while ($row = mysqli_fetch_assoc($get_letter_r)) {
        $get_book_detail_q = "SELECT bc.*, b.* FROM book_copies bc LEFT JOIN books b ON bc.book_id = b.id WHERE bc.copy_code = '{$row['book_id']}'";
        $get_book_detail_r = mysqli_query($conn, $get_book_detail_q);
        $get_book_detail_a = mysqli_fetch_array($get_book_detail_r);
        $book_name = $get_book_detail_a['name'];
        $book_author = $get_book_detail_a['author'];
        $des = $get_book_detail_a['des'];
        $image = $get_book_detail_a['image'];
        $data[] = [
            'id' => $row['id'],
            'book_id' => $row['book_id'],
            'pickup_date' => $row['pickup_date'],
            'supposed_submit_date' => $row['supposed_submit_date'],
            'actual_submit_date' => $row['actual_submit_date'],
            'book_status' => empty($row['status'])?"null":$row['status'],
            'book_name' => $book_name,
            'book_author' => $book_author,
            'book_description' => $des,
            'book_image' => "https://project.conocimientoinfotech.com/Kolkata_Dealer/Admin/".$image
        ];
    }

    $response['status'] = true;
    $response['message'] = "Books fetched successfully";
    $response['data'] = $data;
} else {
    $response['status'] = false;
    $response['message'] = "No books found.";
}

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
