<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');

require '../vendor/autoload.php';

use Kreait\Firebase\Factory;
use GuzzleHttp\Client;

function sendNotification($firebase_token, $title, $body) {
    $serviceAccountKeyPath = '../dealerkolkata-19636-firebase-adminsdk-fbsvc-98a3e8e31b.json';

    $factory = (new Factory)->withServiceAccount($serviceAccountKeyPath);
    $messaging = $factory->createMessaging();

    $message = [
        'token' => $firebase_token,
        'notification' => [
            'title' => $title,
            'body' => $body
        ],
        'data' => [
            'type' => 'student_attendance',
        ],
        'android' => [
            'priority' => 'high'
        ],
        'apns' => [
            'headers' => [
                'apns-priority' => '10' // Immediate delivery on iOS
            ]
        ]
    ];

    try {
        // Send the message
        $messaging->send($message);
        return ['success' => 'Notification sent successfully'];
    } catch (\Kreait\Firebase\Exception\MessagingException $e) {
        // Handle messaging errors (e.g., invalid token)
        error_log('Messaging error: ' . $e->getMessage());
        return ['error1' => $e->getMessage()];
    } catch (Exception $e) {
        // Handle any other general errors
        error_log('General error sending notification: ' . $e->getMessage());
        return ['error' => $e->getMessage()];
    }
}

date_default_timezone_set('Asia/Kolkata');
$created_at = date('Y-m-d H:i:s');

$raw = file_get_contents("php://input");
if (!$raw) {
    echo json_encode(["message" => "Invalid json input", "DeviceResponse" => 1]);
    exit;
}

$data = json_decode($raw, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(["DeviceResponse" => 1]);
    exit;
}

if (!isset($data['MachineID']) || !isset($data['Attendance'])) {
    echo json_encode(["message" => "Machine id and attendance required","DeviceResponse" => 1]);
    exit;
}

$machineId = $data['MachineID'];
$records   = $data['Attendance'];

include '../configDealer.php';

$get_school_id_where_machine_registered_q = "SELECT * FROM school_registered_rfid_machines WHERE machine_id = '{$machineId}'";
$get_school_id_where_machine_registered_r = mysqli_query($conn, $get_school_id_where_machine_registered_q);
if (mysqli_num_rows($get_school_id_where_machine_registered_r) == 0)
{
    echo json_encode(["DeviceResponse" => 0]);
    $conn->close();
    exit;
}
$get_school_id_where_machine_registered_a = mysqli_fetch_array($get_school_id_where_machine_registered_r);
$get_school_id_where_machine_registered = $get_school_id_where_machine_registered_a['school_token'];

foreach ($records as $rec) {
    $punchId     = $conn->real_escape_string($rec['PunchID'] ?? '');
    $punchTime   = $conn->real_escape_string($rec['PunchTime'] ?? '');
    // $punchStatus = $conn->real_escape_string($rec['PunchStatus'] ?? '0');
    
    $dt = DateTime::createFromFormat("dmYHis", $punchTime);
    $mysqlTime = $dt ? $dt->format("Y-m-d H:i:s") : null;
    
    $get_student_id_q = "SELECT id, firebase_token, name FROM students_temp WHERE student_punch_id = '{$punchId}' AND school_token = '{$get_school_id_where_machine_registered}'";
    $get_student_id_r = mysqli_query($conn, $get_student_id_q);
    if (mysqli_num_rows($get_student_id_r) == 0)
    {
        $check_old_U_q = "SELECT punch_status
                        FROM unknown_entry_log
                        WHERE punch_id = '{$punchId}'
                          AND DATE(punch_time) = CURRENT_DATE
                        ORDER BY id DESC
                        LIMIT 1;
                        ";
        $check_old_U_r = mysqli_query($conn, $check_old_U_q);
        if (mysqli_num_rows($check_old_U_r) == 0)
        {
            $U_sql = "INSERT INTO unknown_entry_log 
                (machine_id, punch_id, punch_time, punch_status, created_at) 
                VALUES ('$machineId', '$punchId', '$mysqlTime', 0, '$created_at')";
            $conn->query($U_sql);
        }
        else
        {
            $check_old_U_a = mysqli_fetch_array($check_old_U_r);
            $check_old_U = (string)$check_old_U_a['punch_status'];
            if ($check_old_U == '0')
            {
                $punchStatus = 1;
            }
            else
            {
                $punchStatus = 0;
            }
            $U_sql = "INSERT INTO unknown_entry_log 
                (machine_id, punch_id, punch_time, punch_status, created_at) 
                VALUES ('$machineId', '$punchId', '$mysqlTime', '$punchStatus', '$created_at')";
            $conn->query($U_sql);
        }
        echo json_encode(["DeviceResponse" => 0]);
        $conn->close();
        exit;
    }
    
    $get_student_id_a = mysqli_fetch_array($get_student_id_r);
    $get_student_id = $get_student_id_a['id'];
    $get_student_firebase_id = $get_student_id_a['firebase_token'];
    $get_student_name = $get_student_id_a['name'];
    
    if ($punchId && $mysqlTime) {
        $check_old_q = "SELECT punch_status
                        FROM student_attendance_logs
                        WHERE student_id = '{$get_student_id}' AND punch_id = '{$punchId}'
                          AND DATE(punch_time) = CURRENT_DATE
                        ORDER BY id DESC
                        LIMIT 1;
                        ";
        $check_old_r = mysqli_query($conn, $check_old_q);
        if (mysqli_num_rows($check_old_r) == 0)
        {
            $sql = "INSERT INTO student_attendance_logs 
                    (machine_id, punch_id, punch_time, punch_status, created_at, student_id) 
                    VALUES ('$machineId', '$punchId', '$mysqlTime', 0, '$created_at', '$get_student_id')";
            $conn->query($sql);
            $title = "Student $get_student_name has entered the school";
            $body = "$get_student_name has entered the school";
            sendNotification($get_student_firebase_id, $title, $body);
        }
        else
        {
            $check_old_a = mysqli_fetch_array($check_old_r);
            $check_old = (string)$check_old_a['punch_status'];
            if ($check_old == '0')
            {
                $punchStatus = 1;
                $title = "Student $get_student_name has left the school";
                $body = "$get_student_name has left the school";
            }
            else
            {
                $punchStatus = 0;
                $title = "Student $get_student_name has entered the school";
                $body = "$get_student_name has entered the school";
            }
            
            $sql = "INSERT INTO student_attendance_logs 
                    (machine_id, punch_id, punch_time, punch_status, created_at, student_id) 
                    VALUES ('$machineId', '$punchId', '$mysqlTime', '$punchStatus', '$created_at', '$get_student_id')";
            $conn->query($sql);
            sendNotification($get_student_firebase_id, $title, $body);
        }
    }
}

$conn->close();
echo json_encode(["DeviceResponse" => 0]);
?>
