<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

include "configDealer.php";

date_default_timezone_set('Asia/Kolkata');
try {
    $student_uid   = trim($_POST['student_id']   ?? '');
    $book_copy_id = trim($_POST['book_copy_id'] ?? '');
    $submit_date  = date("Y-m-d H:i:s");
    $book_status = trim($_POST['book_status'] ?? 'Submitted');

    if (!$student_uid || !$book_copy_id || !$submit_date) {
        throw new Exception('All required fields must be filled.');
    }
    $stmt = mysqli_prepare($conn, "SELECT id FROM students_temp WHERE student_uid = ?");
    mysqli_stmt_bind_param($stmt, "s", $student_uid);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $student_id);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
    if(!$student_id)
    {
        echo json_encode([
            'status'  => false,
            'message' => "Student not found!"
        ]);
        mysqli_close($conn);
        exit();
    }

    $stmt = mysqli_prepare($conn, "SELECT id FROM student_assigned_books WHERE book_id = ? AND (actual_submit_date IS NULL OR actual_submit_date = '')");
    mysqli_stmt_bind_param($stmt, "s", $book_copy_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $cat);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($cat) {
        $upd_submit_date_q = "UPDATE student_assigned_books SET actual_submit_date = ?, status = ? WHERE student_id = ? AND book_id = ? AND id = ?";
        $stmt =  mysqli_prepare($conn, $upd_submit_date_q);
        mysqli_stmt_bind_param($stmt, "sssss", $submit_date, $book_status, $student_id, $book_copy_id, $cat);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        
        if ($book_status == 'Submitted')
        {
            $desired_status = "available";
        }
        else
        {
            $desired_status = "lost";
        }
        $old_status = "issued";
        $upd_book_coopi_q = "UPDATE book_copies SET status = ? WHERE copy_code = ? AND status = ?";
        $stmt =  mysqli_prepare($conn, $upd_book_coopi_q);
        mysqli_stmt_bind_param($stmt, "sss", $desired_status, $book_copy_id, $old_status);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        
        // $check_book_issued_by_this_student_q = "SELECT id FROM student_assigned_books WHERE student_id = '{$student_id}' AND book_id = '{$cat}' AND (actual_submit_date != '' OR actual_submit_date IS NULL)";
        // $check_book_issued_by_this_student_R = mysqli_query($conn, $check_book_issued_by_this_student_q);
        // if (mysqli_num_rows($check_book_issued_by_this_student_R) > 0)
        // {
        //     echo json_encode([
        //         'status'  => false,
        //         'message' => "This Book has already been issued to this student"
        //     ]);
        // }
        // $stmt = mysqli_prepare($conn, "INSERT INTO student_assigned_books (student_id, book_id, pickup_date, supposed_submit_date) VALUES (?, ?, ?, ?)");
        // mysqli_stmt_bind_param($stmt, "ssss", $student_id, $cat, $pickup_date, $supposed_submit_date);
        // mysqli_stmt_execute($stmt);
        // // $cat = mysqli_insert_id($conn);
        // mysqli_stmt_close($stmt);
        
        // // echo $cat;
        // $upd_avl_q = "UPDATE book_copies SET status = 'issued' WHERE copy_code = '{$cat}'";
        // $upd_avl_r = mysqli_query($conn, $upd_avl_q);
    }
    else
    {
        echo json_encode([
            'status'  => false,
            'message' => "Book already received!"
        ]);
        mysqli_close($conn);
        exit();
    }

    echo json_encode([
        'status'  => true,
        'message' => "Book submitted successfully"
    ]);

} catch (Exception $e) {
    // error_log("add_book.php Error: " . $e->getMessage());
    echo json_encode([
        'status'  => false,
        'message' => "Something went wrong"
    ]);
}

mysqli_close($conn);
?>
