<?php
// header('Content-Type: application/json');
// include 'configDealer.php';

// $data = json_decode(file_get_contents('php://input'), true);

// if (!$data) {
//     $data = $_POST;
// }

// if (!isset($data['imei']) || !isset($data['latitude']) || !isset($data['longitude'])) {
//     echo json_encode(["status" => "error", "message" => "Missing parameters"]);
//     exit();
// }

// $imei = mysqli_real_escape_string($conn, $data['imei']);
// $latitude = floatval($data['latitude']);
// $longitude = floatval($data['longitude']);
// $speed = isset($data['speed']) ? floatval($data['speed']) : 0.0;

// $sql = "INSERT INTO gps_logs (imei, latitude, longitude, speed, created_at)
//         VALUES ('$imei', '$latitude', '$longitude', '$speed', NOW())";

// if (mysqli_query($conn, $sql)) {
//     echo json_encode(["status" => "success", "message" => "Location uploaded"]);
// } else {
//     echo json_encode(["status" => "error", "message" => mysqli_error($conn)]);
// }
ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'configDealer.php';

// $API_KEY = getenv('GPS_API_KEY') ?: ''; 

$raw = file_get_contents('php://input');
$in  = json_decode($raw, true);
if (!is_array($in)) {
    $in = $_POST;
    if (empty($in)) { $in = $_GET; }
}

function pick($arr, $keys, $default=null) {
    foreach ($keys as $k) { if (isset($arr[$k]) && $arr[$k] !== '') return $arr[$k]; }
    return $default;
}

// $client_key = pick($in, ['api_key','apikey','key','token']);
// if ($GLOBALS['API_KEY'] !== '' && $client_key !== $GLOBALS['API_KEY']) {
//     http_response_code(401);
//     echo json_encode(['status'=>'error','message'=>'Unauthorized']);
//     exit;
// }

// Field aliases the forwarder might send
$imei      = trim((string) pick($in, ['imei','device_id','id','terminal_id']));
$proto     = trim((string) pick($in, ['protocol','proto','pn']));
$serial    = pick($in, ['serial','serial_no','sn','sequence']);
$raw_hex   = trim((string) pick($in, ['raw','raw_hex','packet','hex']));
$sats      = pick($in, ['sats','sat','gps_sats']);
$acc       = pick($in, ['acc','ignition','acc_on']);
$mcc       = pick($in, ['mcc']);
$mnc       = pick($in, ['mnc']);
$lac       = pick($in, ['lac']);
$cell_id   = pick($in, ['cell','cell_id','cid']);

$lat       = pick($in, ['lat','latitude','gps_lat']);
$lon       = pick($in, ['lon','lng','longitude','gps_lon']);
$speed     = pick($in, ['speed','spd','velocity']);
$course    = pick($in, ['course','heading','direction','bearing']);
$altitude  = pick($in, ['alt','altitude']);

$devtime   = pick($in, ['gpstime','gps_time','time','timestamp','device_time','datetime']);

// Some forwarders send GT06 "raw" coordinates (integer) that need scaling.
// GT06: decimal(deg) = (raw_int / 30000) / 60  (from protocol spec). :contentReference[oaicite:4]{index=4}
$lat_raw   = pick($in, ['lat_raw','latitude_raw']);
$lon_raw   = pick($in, ['lon_raw','longitude_raw']);

// If scaled ints provided, prefer those
if ($lat_raw !== null && $lon_raw !== null && is_numeric($lat_raw) && is_numeric($lon_raw)) {
    $lat = ((float)$lat_raw) / 30000.0 / 60.0;
    $lon = ((float)$lon_raw) / 30000.0 / 60.0;
}

$lat      = is_numeric($lat) ? (float)$lat : null;
$lon      = is_numeric($lon) ? (float)$lon : null;
$speed    = is_numeric($speed) ? (float)$speed : null;
$course   = is_numeric($course) ? (float)$course : null;
$altitude = is_numeric($altitude) ? (float)$altitude : null;
$sats     = is_numeric($sats) ? (int)$sats : null;
$serial   = is_numeric($serial) ? (int)$serial : null;
$acc      = ($acc === '1' || $acc === 1 || $acc === true || $acc === 'true') ? 1 : ( ($acc === '0' || $acc === 0 || $acc === 'false') ? 0 : null );
$mcc      = is_numeric($mcc) ? (int)$mcc : null;
$mnc      = is_numeric($mnc) ? (int)$mnc : null;
$lac      = is_numeric($lac) ? (int)$lac : null;
$cell_id  = is_numeric($cell_id) ? (int)$cell_id : null;

if ($imei === '') {
    echo json_encode(['status'=>'error','message'=>'Missing IMEI']);
    exit;
}
if ($lat === null || $lon === null) {
    // allow raw_hex-only insert (so nothing is lost); but you can enforce coords if you want
    if ($raw_hex === '') {
        echo json_encode(['status'=>'error','message'=>'Missing coordinates']);
        exit;
    }
}

// Parse device time if present (supports seconds, ms, ISO, or epoch)
$device_time = null;
if (!empty($devtime)) {
    if (is_numeric($devtime)) {
        // epoch seconds or ms
        if ((int)$devtime > 2000000000) {
            $device_time = date('Y-m-d H:i:s', (int)round(((int)$devtime)/1000));
        } else {
            $device_time = date('Y-m-d H:i:s', (int)$devtime);
        }
    } else {
        $t = strtotime($devtime);
        if ($t !== false) $device_time = date('Y-m-d H:i:s', $t);
    }
}

$stmt = mysqli_prepare(
    $conn,
    "INSERT INTO gps_logs
     (imei, lat, lon, speed_kmh, course_deg, altitude_m, sats, mcc, mnc, lac, cell_id, acc, raw_hex, proto, serial_no, device_time)
     VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
);
if (!$stmt) {
    echo json_encode(['status'=>'error','message'=>mysqli_error($conn)]);
    exit;
}

mysqli_stmt_bind_param(
    $stmt,
    "sdddddi" . "iiiii" . "ssi" . "s",
    $imei,
    $lat, $lon, $speed, $course, $altitude,
    $sats,
    $mcc, $mnc, $lac, $cell_id,
    $acc,
    $raw_hex,
    $proto,
    $serial,
    $device_time
);

$ok = mysqli_stmt_execute($stmt);
if (!$ok) {
    echo json_encode(['status'=>'error','message'=>mysqli_error($conn)]);
    exit;
}

// Some uploaders expect plain "OK" (not JSON). Support `plain=1`.
$plain = pick($in, ['plain','ok','text']);
if ($plain === '1' || strtolower((string)$plain) === 'ok') {
    header('Content-Type: text/plain');
    echo "OK";
    exit;
}

echo json_encode([
  'status'=>'success',
  'message'=>'Location stored',
  'stored'=>[
    'imei'=>$imei,
    'lat'=>$lat, 'lon'=>$lon,
    'speed_kmh'=>$speed, 'course_deg'=>$course,
    'time'=>$device_time
  ]
]);


