<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With');

if (empty($_POST['subject']) || empty($_POST['teacher_id']) || empty($_POST['message'])) {
    echo json_encode(array("status" => false, "message" => "Input parameters empty"));
    exit();
}

// if (!isset($_FILES['prove_doc']) || $_FILES['prove_doc']['error'] !== UPLOAD_ERR_OK) {
//     echo json_encode(array("status" => false, "message" => "File upload error or no file sent"));
//     exit();
// }

include 'configDealer.php';
date_default_timezone_set('Asia/Kolkata');

$subject = trim($_POST['subject']);
$user_id = trim($_POST['teacher_id']);
$message = trim($_POST['message']);
$submit_date  = date("Y-m-d H:i:s");

// Set upload directory
$upload_dir = 'uploads/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true); // create folder if it doesn't exist
}

// Get file details
if (!empty($_FILES['prove_doc']))
{
    $file_tmp = $_FILES['prove_doc']['tmp_name'];
    $file_name = basename($_FILES['prove_doc']['name']);
    $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
    $allowed_ext = ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'];
    
    // Validate file extension
    if (!in_array(strtolower($file_ext), $allowed_ext)) {
        echo json_encode(array("status" => false, "message" => "Invalid file type. Allowed types: jpg, png, pdf, doc, docx"));
        exit();
    }
    
    // Create unique file name to avoid overwriting
    $new_file_name = uniqid('proof_', true) . '.' . $file_ext;
    $destination = $upload_dir . $new_file_name;
    
    // Move uploaded file
    if (!move_uploaded_file($file_tmp, $destination)) {
        echo json_encode(array("status" => false, "message" => "Failed to save uploaded file"));
        exit();
    }
    
    // Save file path to DB
    $documents = mysqli_real_escape_string($conn, $destination);
    $documents = "https://project.conocimientoinfotech.com/Kolkata_Dealer/api/".$documents;
}
else
{
    $documents = null;
}

$ins_q = "INSERT INTO teacher_posted_application(teacher_id, title, content, current_status, prove_doc, created_at) 
          VALUES('{$user_id}', '{$subject}', '{$message}', 'Pending', '{$documents}', '{$submit_date}')";

$ins_r = mysqli_query($conn, $ins_q);

if ($ins_r) {
    echo json_encode(array("status" => true, "message" => "Successfully uploaded application"));
} else {
    echo json_encode(array("status" => false, "message" => "Unable to upload application"));
}

mysqli_close($conn);
exit();
?>
